/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.utils;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.registry.training.SupportStack;

public class TrainingSupportUtils {
    public static ListTag serializeNBT(List<SupportStack> factors) {
        ListTag result = new ListTag();
        for (SupportStack factor : factors) {
            SupportStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)factor).resultOrPartial(error -> Umapyoi.getLogger().error("Failed to encode SupportStack : {}", error)).ifPresent(tag -> result.add(tag));
        }
        return result;
    }

    public static List<SupportStack> deserializeNBT(CompoundTag compound) {
        ArrayList list = Lists.newArrayList();
        compound.getList("supports", 10).forEach(tag -> SupportStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, tag).resultOrPartial(error -> Umapyoi.getLogger().error("Failed to parse SupportStack : {}", error)).ifPresent(result -> list.add(result)));
        return list;
    }

    public static Component getTranslatedSupportCardName(ResourceLocation name) {
        return Component.translatable((String)(Util.makeDescriptionId((String)"support_card", (ResourceLocation)name) + ".name"));
    }
}

