/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.tracen.umapyoi.item.data.DataComponentsTypeRegistry;
import net.tracen.umapyoi.item.data.DataLocation;
import net.tracen.umapyoi.item.data.GachaRankingData;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.umadata.Motivations;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.registry.umadata.UmaDataBasicStatus;
import net.tracen.umapyoi.registry.umadata.UmaDataExtraStatus;
import net.tracen.umapyoi.registry.umadata.UmaDataSkills;
import net.tracen.umapyoi.registry.umadata.UmaDataTranining;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.ResultRankingUtils;

public class UmaSoulUtils {
    public static Component getTranslatedUmaName(ItemStack stack) {
        return UmaSoulUtils.getTranslatedUmaName(UmaSoulUtils.getName(stack));
    }

    public static Component getTranslatedUmaName(ResourceLocation name) {
        return Component.translatable((String)Util.makeDescriptionId((String)"umadata", (ResourceLocation)name));
    }

    public static ItemStack initUmaSoul(ItemStack stack, ResourceLocation name, UmaData data) {
        ItemStack result = stack.copy();
        result.set(DataComponentsTypeRegistry.DATA_LOCATION, (Object)new DataLocation(name));
        GachaRanking ranking = data.ranking();
        result.set(DataComponentsTypeRegistry.GACHA_RANKING, (Object)new GachaRankingData(ranking));
        result.set(DataComponentsTypeRegistry.UMADATA_BASIC_STATUS, (Object)UmaDataBasicStatus.init(data.property()));
        result.set(DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS, (Object)UmaDataBasicStatus.init(data.maxProperty()));
        result.set(DataComponentsTypeRegistry.UMADATA_STATUS_RATE, (Object)UmaDataBasicStatus.init(data.propertyRate()));
        result.set(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)new UmaDataSkills(UmaDataSkills.DEFAULT.skillSlot(), 0, List.of(data.uniqueSkill())));
        result.set(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)new UmaDataExtraStatus(data.property()[4] * 200, 0, ResultRankingUtils.generateRanking(result), Motivations.NORMAL));
        result.set(DataComponents.RARITY, (Object)(ranking == GachaRanking.SSR ? Rarity.EPIC : (ranking == GachaRanking.SR ? Rarity.UNCOMMON : Rarity.COMMON)));
        result.set(DataComponentsTypeRegistry.UMADATA_TRAINING, (Object)new UmaDataTranining(1, 6));
        return result;
    }

    public static ResourceLocation getName(ItemStack stack) {
        return ((DataLocation)stack.getOrDefault((DataComponentType)DataComponentsTypeRegistry.DATA_LOCATION.get(), (Object)new DataLocation(UmaData.DEFAULT_UMA_ID))).name();
    }

    public static UmaDataBasicStatus getProperty(ItemStack stack) {
        return (UmaDataBasicStatus)stack.getOrDefault((DataComponentType)DataComponentsTypeRegistry.UMADATA_BASIC_STATUS.get(), (Object)new UmaDataBasicStatus(1, 1, 1, 1, 1));
    }

    public static UmaDataBasicStatus getPropertyRate(ItemStack stack) {
        return (UmaDataBasicStatus)stack.getOrDefault((DataComponentType)DataComponentsTypeRegistry.UMADATA_STATUS_RATE.get(), (Object)new UmaDataBasicStatus(0, 0, 0, 0, 0));
    }

    public static UmaDataBasicStatus getMaxProperty(ItemStack stack) {
        return (UmaDataBasicStatus)stack.getOrDefault((DataComponentType)DataComponentsTypeRegistry.UMADATA_MAX_BASIC_STATUS.get(), (Object)new UmaDataBasicStatus(12, 12, 12, 12, 12));
    }

    public static Motivations getMotivation(ItemStack stack) {
        return ((UmaDataExtraStatus)stack.getOrDefault(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)UmaDataExtraStatus.DEFAULT)).motivation();
    }

    public static void setMotivation(ItemStack stack, Motivations motivation) {
        stack.update(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)UmaDataExtraStatus.DEFAULT, data -> new UmaDataExtraStatus(data.actionPoint(), data.extraActionPoint(), data.resultRanking(), motivation));
    }

    public static List<ResourceLocation> getSkills(ItemStack stack) {
        return ((UmaDataSkills)stack.getOrDefault(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)UmaDataSkills.DEFAULT)).skills();
    }

    public static boolean hasSkill(ItemStack stack, ResourceLocation skill) {
        for (ResourceLocation loc : ((UmaDataSkills)stack.getOrDefault(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)UmaDataSkills.DEFAULT)).skills()) {
            if (!skill.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }

    public static void setSkill(ItemStack stack, int index, ResourceLocation skill) {
        stack.update(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)UmaDataSkills.DEFAULT, data -> {
            ArrayList<ResourceLocation> skills = new ArrayList<ResourceLocation>();
            skills.addAll(data.skills());
            skills.set(index, skill);
            return new UmaDataSkills(data.skillSlot(), data.selectedSkill(), skills);
        });
    }

    public static void addSkill(ItemStack stack, ResourceLocation skill) {
        stack.update(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)UmaDataSkills.DEFAULT, data -> {
            ArrayList<ResourceLocation> skills = new ArrayList<ResourceLocation>();
            skills.addAll(data.skills());
            skills.add(skill);
            return new UmaDataSkills(data.skillSlot(), data.selectedSkill(), skills);
        });
    }

    public static int getSelectedSkillIndex(ItemStack stack) {
        return ((UmaDataSkills)stack.getOrDefault(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)UmaDataSkills.DEFAULT)).selectedSkill();
    }

    public static void setSelectedSkill(ItemStack stack, int slot) {
        stack.update(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)UmaDataSkills.DEFAULT, data -> new UmaDataSkills(data.skillSlot(), slot, data.skills()));
    }

    public static ResourceLocation getSelectedSkill(ItemStack stack) {
        ResourceLocation skill = UmaSoulUtils.getSkills(stack).get(UmaSoulUtils.getSelectedSkillIndex(stack));
        return skill == null ? UmaSkillRegistry.BASIC_PACE.getId() : skill;
    }

    public static int getSkillSlots(ItemStack stack) {
        return ((UmaDataSkills)stack.get(DataComponentsTypeRegistry.UMADATA_SKILLS)).skillSlot();
    }

    public static void setSkillSlots(ItemStack stack, int slots) {
        stack.update(DataComponentsTypeRegistry.UMADATA_SKILLS, (Object)UmaDataSkills.DEFAULT, data -> new UmaDataSkills(slots, data.selectedSkill(), data.skills()));
    }

    public static boolean hasEmptySkillSlot(ItemStack stack) {
        int slots = ((UmaDataSkills)stack.get(DataComponentsTypeRegistry.UMADATA_SKILLS)).skillSlot();
        int learned = ((UmaDataSkills)stack.get(DataComponentsTypeRegistry.UMADATA_SKILLS)).skills().size();
        return learned < slots;
    }

    public static void selectFormerSkill(ItemStack stack) {
        if (UmaSoulUtils.getSkills(stack).size() <= 1) {
            return;
        }
        int slot = UmaSoulUtils.getSelectedSkillIndex(stack);
        UmaSoulUtils.setSelectedSkill(stack, slot == 0 ? UmaSoulUtils.getSkills(stack).size() - 1 : slot - 1);
    }

    public static void selectLatterSkill(ItemStack stack) {
        if (UmaSoulUtils.getSkills(stack).size() <= 1) {
            return;
        }
        int slot = UmaSoulUtils.getSelectedSkillIndex(stack);
        UmaSoulUtils.setSelectedSkill(stack, slot == UmaSoulUtils.getSkills(stack).size() - 1 ? 0 : slot + 1);
    }

    public static int getActionPoint(ItemStack stack) {
        return Math.max(((UmaDataExtraStatus)stack.get(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS)).actionPoint(), 0);
    }

    public static void setActionPoint(ItemStack stack, int ap) {
        stack.update(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)UmaDataExtraStatus.DEFAULT, data -> new UmaDataExtraStatus(ap, data.extraActionPoint(), data.resultRanking(), data.motivation()));
    }

    public static void addActionPoint(ItemStack stack, int ap) {
        UmaSoulUtils.setActionPoint(stack, Math.min(UmaSoulUtils.getActionPoint(stack) + ap, UmaSoulUtils.getMaxActionPoint(stack)));
    }

    public static int getMaxActionPoint(ItemStack stack) {
        return ((UmaDataExtraStatus)stack.get(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS)).extraActionPoint() + UmaSoulUtils.getProperty(stack).wisdom() * (int)(200.0 * (1.0 + (double)UmaSoulUtils.getPropertyRate(stack).wisdom() / 100.0));
    }

    public static int getExtraActionPoint(ItemStack stack) {
        return Math.max(((UmaDataExtraStatus)stack.get(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS)).extraActionPoint(), 0);
    }

    public static void setExtraActionPoint(ItemStack stack, int ap) {
        stack.update(DataComponentsTypeRegistry.UMADATA_EXTRA_STATUS, (Object)UmaDataExtraStatus.DEFAULT, data -> new UmaDataExtraStatus(data.actionPoint(), ap, data.resultRanking(), data.motivation()));
    }

    public static int getPhysique(ItemStack stack) {
        return ((UmaDataTranining)stack.get(DataComponentsTypeRegistry.UMADATA_TRAINING)).physique();
    }

    public static void setPhysique(ItemStack stack, int phy) {
        stack.update(DataComponentsTypeRegistry.UMADATA_TRAINING, (Object)new UmaDataTranining(1, 6), data -> new UmaDataTranining(phy, data.talent()));
    }

    public static void downPhysique(ItemStack stack) {
        int phy = Math.max(UmaSoulUtils.getPhysique(stack) - 1, 0);
        UmaSoulUtils.setPhysique(stack, phy);
    }

    public static int getLearningTimes(ItemStack stack) {
        return ((UmaDataTranining)stack.get(DataComponentsTypeRegistry.UMADATA_TRAINING)).talent();
    }

    public static void setLearningTimes(ItemStack stack, int learns) {
        stack.update(DataComponentsTypeRegistry.UMADATA_TRAINING, (Object)new UmaDataTranining(1, 6), data -> new UmaDataTranining(data.physique(), learns));
    }

    public static void downLearningTimes(ItemStack stack) {
        int learns = Math.max(UmaSoulUtils.getLearningTimes(stack) - 1, 0);
        UmaSoulUtils.setLearningTimes(stack, learns);
    }
}

