/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tracen.umapyoi.container.TrainingFacilityContainer;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class TrainingFacilityScreen
extends AbstractContainerScreen<TrainingFacilityContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("umapyoi", "textures/gui/training_snap.png");

    public TrainingFacilityScreen(TrainingFacilityContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 202;
    }

    public void m_88315_(GuiGraphics graphic, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphic);
        super.m_88315_(graphic, mouseX, mouseY, partialTicks);
        this.m_280072_(graphic, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphic, int mouseX, int mouseY) {
        graphic.m_280430_(this.f_96547_, this.f_96539_, this.f_97726_ / 2 - this.f_96547_.m_92724_(this.f_96539_.m_7532_()) / 2, this.f_97729_ - 3, 0xFFFFFF);
        graphic.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics graphic, float partialTicks, int mouseX, int mouseY) {
        if (this.f_96541_ == null) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderSupportBG(graphic);
        this.renderTrainingAnim(graphic);
        this.renderSupportTypes(graphic);
        this.renderUmaSoulPhysique(graphic);
    }

    private void renderUmaSoulPhysique(GuiGraphics graphic) {
        ItemStack soul = ((TrainingFacilityContainer)this.m_6262_()).inventory.getStackInSlot(0);
        if (soul.m_41720_() instanceof UmaSoulItem) {
            if (UmaSoulUtils.getGrowth(soul) == Growth.RETIRED) {
                return;
            }
            graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 102, this.f_97736_ + 103, 0, 246, 65, 5);
            int training_times = 5 - UmaSoulUtils.getPhysique(soul);
            graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 102, this.f_97736_ + 103, 0, 251, training_times * 13, 5);
        }
    }

    private void renderSupportTypes(GuiGraphics graphic) {
        int i;
        int[] types = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        block9: for (i = 1; i < 7; ++i) {
            ItemStack stack = ((TrainingFacilityContainer)this.m_6262_()).inventory.getStackInSlot(i);
            Item item = stack.m_41720_();
            if (!(item instanceof SupportContainer)) continue;
            SupportContainer support = (SupportContainer)item;
            switch (support.getSupportType((Level)this.f_96541_.f_91073_, stack)) {
                case SPEED: {
                    types[0] = types[0] + 1;
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 9 + 0, this.f_97736_ + 42, 3, 219, 12, 12);
                    continue block9;
                }
                case STAMINA: {
                    types[1] = types[1] + 1;
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 9 + 23, this.f_97736_ + 42, 26, 219, 12, 12);
                    continue block9;
                }
                case STRENGTH: {
                    types[2] = types[2] + 1;
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 9 + 46, this.f_97736_ + 42, 49, 219, 12, 12);
                    continue block9;
                }
                case GUTS: {
                    types[3] = types[3] + 1;
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 9 + 69, this.f_97736_ + 42, 72, 219, 12, 12);
                    continue block9;
                }
                case WISDOM: {
                    types[4] = types[4] + 1;
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 9 + 92, this.f_97736_ + 42, 95, 219, 12, 12);
                    continue block9;
                }
                case FRIENDSHIP: {
                    types[5] = types[5] + 1;
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 9 + 115, this.f_97736_ + 42, 118, 219, 12, 12);
                    continue block9;
                }
                case GROUP: {
                    types[6] = types[6] + 1;
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 9 + 138, this.f_97736_ + 42, 141, 219, 12, 12);
                    continue block9;
                }
            }
        }
        for (i = 0; i < 7; ++i) {
            if (types[i] <= 0) continue;
            graphic.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)String.valueOf(types[i])), this.f_97735_ + 23 + i * 23, this.f_97736_ + 44, 8835080);
        }
    }

    private void renderSupportBG(GuiGraphics graphic) {
        SupportContainer support;
        Item item;
        ItemStack stack;
        int i;
        block12: for (i = 1; i < 4; ++i) {
            stack = ((TrainingFacilityContainer)this.m_6262_()).inventory.getStackInSlot(i);
            item = stack.m_41720_();
            if (!(item instanceof SupportContainer)) continue;
            support = (SupportContainer)item;
            switch (support.getSupportLevel((Level)this.f_96541_.f_91073_, stack)) {
                case EASTER_EGG: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 7 + (i - 1) * 27, this.f_97736_ + 14, 171, 205, 26, 26);
                    continue block12;
                }
                case R: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 7 + (i - 1) * 27, this.f_97736_ + 14, 171, 205, 26, 26);
                    continue block12;
                }
                case SR: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 7 + (i - 1) * 27, this.f_97736_ + 14, 198, 205, 26, 26);
                    continue block12;
                }
                case SSR: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 7 + (i - 1) * 27, this.f_97736_ + 14, 225, 205, 26, 26);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + support.getSupportLevel((Level)this.f_96541_.f_91073_, stack));
                }
            }
        }
        block13: for (i = 4; i < 7; ++i) {
            stack = ((TrainingFacilityContainer)this.m_6262_()).inventory.getStackInSlot(i);
            item = stack.m_41720_();
            if (!(item instanceof SupportContainer)) continue;
            support = (SupportContainer)item;
            switch (support.getSupportLevel((Level)this.f_96541_.f_91073_, stack)) {
                case EASTER_EGG: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 89 + (i - 4) * 27, this.f_97736_ + 14, 171, 205, 26, 26);
                    continue block13;
                }
                case R: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 89 + (i - 4) * 27, this.f_97736_ + 14, 171, 205, 26, 26);
                    continue block13;
                }
                case SR: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 89 + (i - 4) * 27, this.f_97736_ + 14, 198, 205, 26, 26);
                    continue block13;
                }
                case SSR: {
                    graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 89 + (i - 4) * 27, this.f_97736_ + 14, 225, 205, 26, 26);
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected value: " + support.getSupportLevel((Level)this.f_96541_.f_91073_, stack));
                }
            }
        }
    }

    private void renderTrainingAnim(GuiGraphics graphic) {
        int l = ((TrainingFacilityContainer)this.f_97732_).getProgressionScaled();
        int n = ((TrainingFacilityContainer)this.f_97732_).getAnimation();
        graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 10 + l, this.f_97736_ + 68, 207, 88 + n * 24, 24, 24);
        graphic.m_280218_(BACKGROUND_TEXTURE, this.f_97735_ + 8, this.f_97736_ + 64, 181, 84, 25, 27);
    }
}

