/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.entity.TrainingFacilityBlockEntity;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.training.SupportContainer;

public class TrainingFacilityContainer
extends AbstractContainerMenu {
    public final TrainingFacilityBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData containerData;
    private final ContainerLevelAccess canInteractWithCallable;

    public TrainingFacilityContainer(int windowId, Inventory playerInventory, TrainingFacilityBlockEntity tileEntity, ContainerData cookingPotDataIn) {
        super((MenuType)ContainerRegistry.TRAINING_FACILITY.get(), windowId);
        int i;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.containerData = cookingPotDataIn;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        int startX = 8;
        this.m_38897_((Slot)new TrainingUmaSlot(tileEntity, (IItemHandler)this.inventory, 0, 80, 98));
        for (i = 1; i < 4; ++i) {
            this.m_38897_((Slot)new TrainingSupportSlot(tileEntity, (IItemHandler)this.inventory, i, (i - 1) * 27 + 12, 19));
        }
        for (i = 4; i < 7; ++i) {
            this.m_38897_((Slot)new TrainingSupportSlot(tileEntity, (IItemHandler)this.inventory, i, (i - 4) * 27 + 94, 19));
        }
        int startPlayerInvY = 120;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column, startX + column * 18, startPlayerInvY + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * 18, 178));
        }
        this.m_38884_(cookingPotDataIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            if (index >= 0 && index < 7) {
                if (!this.m_38903_(itemStack1, 7, 43, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack1, itemStack);
            } else if (index >= 7 && index >= 7 && index < 43 && !this.m_38903_(itemStack1, 0, 7, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemStack1);
        }
        return itemStack;
    }

    private static TrainingFacilityBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof TrainingFacilityBlockEntity) {
            return (TrainingFacilityBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public TrainingFacilityContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, TrainingFacilityContainer.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean m_6875_(Player playerIn) {
        return TrainingFacilityContainer.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)BlockRegistry.TRAINING_FACILITY.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressionScaled() {
        int i = this.containerData.m_6413_(0);
        return i != 0 ? i * 130 / 260 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAnimation() {
        int i = this.containerData.m_6413_(0);
        return i != 0 ? i % 4 : 0;
    }

    public static class TrainingUmaSlot
    extends SlotItemHandler {
        private final TrainingFacilityBlockEntity tileEntity;

        public TrainingUmaSlot(TrainingFacilityBlockEntity tileEntity, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.tileEntity = tileEntity;
        }

        public boolean m_5857_(ItemStack stack) {
            if (stack.m_150930_((Item)ItemRegistry.UMA_SOUL.get())) {
                for (int i = 1; i < 7; ++i) {
                    ItemStack other = this.getItemHandler().getStackInSlot(i);
                    if (other.m_41619_()) continue;
                    Item item = other.m_41720_();
                    if (item instanceof SupportContainer) {
                        SupportContainer support = (SupportContainer)item;
                        if (support.canSupport(this.tileEntity.m_58904_(), other).test(stack)) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class TrainingSupportSlot
    extends SlotItemHandler {
        private final TrainingFacilityBlockEntity tileEntity;

        public TrainingSupportSlot(TrainingFacilityBlockEntity tileEntity, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.tileEntity = tileEntity;
        }

        public boolean m_5857_(ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof SupportContainer) {
                SupportContainer support = (SupportContainer)item;
                ItemStack soul = this.getItemHandler().getStackInSlot(0);
                for (int i = 1; i < 7; ++i) {
                    ItemStack other = this.getItemHandler().getStackInSlot(i);
                    if (!soul.m_41619_() && !support.canSupport(this.tileEntity.m_58904_(), stack).test(soul)) {
                        return false;
                    }
                    if (i == this.getSlotIndex() || other.m_41619_() || support.canSupport(this.tileEntity.m_58904_(), stack).test(other)) continue;
                    return false;
                }
            }
            return true;
        }

        public int m_5866_(ItemStack stack) {
            return 1;
        }
    }
}

