/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events.handler;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.effect.MobEffectRegistry;
import net.tracen.umapyoi.events.ApplyFactorEvent;
import net.tracen.umapyoi.events.ApplyTrainingSupportEvent;
import net.tracen.umapyoi.events.SkillEvent;
import net.tracen.umapyoi.registry.umadata.Motivations;
import net.tracen.umapyoi.utils.ResultRankingUtils;
import net.tracen.umapyoi.utils.UmaSkillUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

@Mod.EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void onDamageDownMotivation(LivingDamageEvent event) {
        LivingEntity entityLiving = event.getEntity();
        ItemStack soul = UmapyoiAPI.getUmaSoul(entityLiving);
        if (soul.m_41619_()) {
            return;
        }
        if ((double)event.getAmount() < (Double)UmapyoiConfig.DAMAGE_MOTIVATION_EFFECT.get()) {
            return;
        }
        if ((Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get() > 0.0 && entityLiving.m_9236_().m_213780_().m_188500_() <= (Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get()) {
            UmaStatusUtils.downMotivation(soul);
        }
    }

    @SubscribeEvent
    public static void onDamagePanicking(LivingDamageEvent event) {
        LivingEntity entityLiving = event.getEntity();
        ItemStack soul = UmapyoiAPI.getUmaSoul(entityLiving);
        if (soul.m_41619_() || UmaSoulUtils.getMotivation(soul) != Motivations.BAD) {
            return;
        }
        if ((double)event.getAmount() < (Double)UmapyoiConfig.DAMAGE_MOTIVATION_EFFECT.get()) {
            return;
        }
        if ((Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get() > 0.0 && entityLiving.m_9236_().m_213780_().m_188500_() <= (Double)UmapyoiConfig.CHANCE_MOTIVATION_EFFECT.get()) {
            entityLiving.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.PANICKING.get(), 3600));
        }
    }

    @SubscribeEvent
    public static void onTrainingFinished(ApplyTrainingSupportEvent.Post event) {
        ItemStack umaSoul = event.getUmaSoul();
        UmaSkillUtils.syncActionPoint(umaSoul);
        CompoundTag tag = umaSoul.m_41784_();
        tag.m_128405_("resultRanking", ResultRankingUtils.generateRanking(umaSoul));
    }

    @SubscribeEvent
    public static void onFactorFinished(ApplyFactorEvent.Post event) {
        ItemStack umaSoul = event.getUmaSoul();
        UmaSkillUtils.syncActionPoint(umaSoul);
        CompoundTag tag = umaSoul.m_41784_();
        tag.m_128405_("resultRanking", ResultRankingUtils.generateRanking(umaSoul));
    }

    @SubscribeEvent
    public static void onSkillLearned(SkillEvent.LearnSkillEvent event) {
        ItemStack umaSoul = event.getUmaSoul();
        UmaSkillUtils.syncActionPoint(umaSoul);
        CompoundTag tag = umaSoul.m_41784_();
        tag.m_128405_("resultRanking", ResultRankingUtils.generateRanking(umaSoul));
    }
}

