/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events.handler;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.data.tag.UmapyoiBlockTags;
import net.tracen.umapyoi.events.ApplyUmasoulAttributeEvent;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.UmapyoiAttributesRegistry;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

@Mod.EventBusSubscriber
public class PassiveSkillEvents {
    public static final UUID PASSIVEUUID = UUID.fromString("306e284a-8a74-11ee-b9d1-0242ac120002");
    public static final UUID SPRINTUUID = UUID.fromString("0591c346-7c25-4171-b2bd-66e9824f1c90");

    @SubscribeEvent
    public static void testPassiveSkill_im(ApplyUmasoulAttributeEvent event) {
        ItemStack soul = event.getUmaSoul();
        if (UmaSoulUtils.hasSkill(soul, UmaSkillRegistry.INQUISITIVE_MIND.getId())) {
            boolean speedFlag = UmaSoulUtils.getProperty(soul)[UmaStatusUtils.StatusType.SPEED.getId()] >= 12;
            boolean wisdomFlag = UmaSoulUtils.getProperty(soul)[UmaStatusUtils.StatusType.WISDOM.getId()] >= 12;
            event.getAttributes().put((Object)Attributes.f_22283_, (Object)new AttributeModifier(PASSIVEUUID, "passive_speed_bonus", speedFlag && wisdomFlag ? 0.075 : 0.05, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    @SubscribeEvent
    public static void testPassiveSkill_att(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        ItemStack soul = UmapyoiAPI.getUmaSoul((LivingEntity)player);
        if (UmaSoulUtils.hasSkill(soul, UmaSkillRegistry.DIG_SPEED.getId())) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.1f);
        }
    }

    @SubscribeEvent
    public static void sprintSpeedTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        AttributeInstance movementSpeed = player.m_21051_(Attributes.f_22279_);
        AttributeModifier speedModifier = new AttributeModifier(SPRINTUUID, "sprint_speed_bonus", player.m_21133_((Attribute)UmapyoiAttributesRegistry.SPRINT_SPEED.get()), (Boolean)UmapyoiConfig.UMASOUL_SPEED_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).m_41619_()) {
            movementSpeed.m_22130_(speedModifier);
            return;
        }
        if (player.m_20142_()) {
            if (!movementSpeed.m_22109_(speedModifier)) {
                movementSpeed.m_22118_(speedModifier);
            }
        } else {
            movementSpeed.m_22130_(speedModifier);
        }
    }

    @SubscribeEvent
    public static void passiveStepHeight(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        AttributeInstance stepHeight = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        AttributeModifier heightModifier = new AttributeModifier(PASSIVEUUID, "passive_skill_height", 0.5, AttributeModifier.Operation.ADDITION);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).m_41619_()) {
            stepHeight.m_22130_(heightModifier);
            return;
        }
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.MOUNTAIN_CLIMBER.getId())) {
            if (!stepHeight.m_22109_(heightModifier)) {
                stepHeight.m_22118_(heightModifier);
            }
        } else {
            stepHeight.m_22130_(heightModifier);
        }
    }

    @SubscribeEvent
    public static void passiveTurfRunner(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        AttributeInstance movementSpeed = player.m_21051_((Attribute)UmapyoiAttributesRegistry.SPRINT_SPEED.get());
        AttributeModifier test_speed = new AttributeModifier(PASSIVEUUID, "passive_skill_turf", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).m_41619_()) {
            movementSpeed.m_22130_(test_speed);
            return;
        }
        BlockPos groundPos = player.m_20186_() % 1.0 < 0.5 ? player.m_20183_().m_7495_() : player.m_20183_();
        BlockState groundBlock = event.player.m_9236_().m_8055_(groundPos);
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.TURF_RUNNER.getId())) {
            PassiveSkillEvents.handleMovementModifier(movementSpeed, test_speed, groundBlock, UmapyoiBlockTags.TRACK_TURF);
        }
    }

    @SubscribeEvent
    public static void passiveDirtRunner(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        AttributeInstance movementSpeed = player.m_21051_((Attribute)UmapyoiAttributesRegistry.SPRINT_SPEED.get());
        AttributeModifier test_speed = new AttributeModifier(PASSIVEUUID, "passive_skill_dirt", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).m_41619_()) {
            movementSpeed.m_22130_(test_speed);
            return;
        }
        BlockPos groundPos = player.m_20186_() % 1.0 < 0.5 ? player.m_20183_().m_7495_() : player.m_20183_();
        BlockState groundBlock = event.player.m_9236_().m_8055_(groundPos);
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.DIRT_RUNNER.getId())) {
            PassiveSkillEvents.handleMovementModifier(movementSpeed, test_speed, groundBlock, UmapyoiBlockTags.TRACK_DIRT);
        }
    }

    @SubscribeEvent
    public static void passiveSnowRunner(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        AttributeInstance movementSpeed = player.m_21051_((Attribute)UmapyoiAttributesRegistry.SPRINT_SPEED.get());
        AttributeModifier test_speed = new AttributeModifier(PASSIVEUUID, "passive_skill_snow", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (UmapyoiAPI.getUmaSoul((LivingEntity)player).m_41619_()) {
            movementSpeed.m_22130_(test_speed);
            return;
        }
        BlockPos groundPos = player.m_20186_() % 1.0 < 0.5 ? player.m_20183_().m_7495_() : player.m_20183_();
        BlockState groundBlock = event.player.m_9236_().m_8055_(groundPos);
        if (UmaSoulUtils.hasSkill(UmapyoiAPI.getUmaSoul((LivingEntity)player), UmaSkillRegistry.SNOW_RUNNER.getId())) {
            PassiveSkillEvents.handleMovementModifier(movementSpeed, test_speed, groundBlock, event.player.m_146900_(), UmapyoiBlockTags.TRACK_SNOW);
        }
    }

    private static void handleMovementModifier(AttributeInstance attribute, AttributeModifier modifier, BlockState groundBlock, TagKey<Block> tagIn) {
        PassiveSkillEvents.handleMovementModifier(attribute, modifier, groundBlock, groundBlock, tagIn);
    }

    private static void handleMovementModifier(AttributeInstance attribute, AttributeModifier modifier, BlockState groundBlock, BlockState feetblock, TagKey<Block> tagIn) {
        if (groundBlock.m_60795_() && feetblock.m_60795_()) {
            return;
        }
        if (!groundBlock.m_204336_(tagIn) && !feetblock.m_204336_(tagIn)) {
            if (attribute.m_22109_(modifier)) {
                attribute.m_22130_(modifier);
            }
            return;
        }
        if (!attribute.m_22109_(modifier)) {
            attribute.m_22118_(modifier);
        }
    }
}

