/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.tracen.umapyoi.item.FadedUmaSoulItem;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.SupportCardItem;
import net.tracen.umapyoi.item.UmaCostumeItem;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.UmaFactorRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.UmaFactorUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmapyoiCreativeGroup {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"umapyoi");
    public static final RegistryObject<CreativeModeTab> UMAPYOI_ITEMS = CREATIVE_MODE_TABS.register("umapyoi", () -> CreativeModeTab.builder().m_257737_(() -> ((Item)((Item)ItemRegistry.HACHIMI_MID.get())).m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.umapyoi")).m_257501_((features, output) -> ItemRegistry.ITEMS.getEntries().forEach(item -> {
        if (item == ItemRegistry.BLANK_UMA_SOUL) {
            return;
        }
        if (item == ItemRegistry.UMA_COSTUME) {
            UmapyoiCreativeGroup.fillCostume(features, output);
            return;
        }
        if (item == ItemRegistry.UMA_FACTOR_ITEM) {
            UmapyoiCreativeGroup.fillFactorContainer(output);
            return;
        }
        if (item == ItemRegistry.UMA_SOUL || item == ItemRegistry.UMA_SOUL_DISPLAY) {
            return;
        }
        if (item == ItemRegistry.SUPPORT_CARD) {
            return;
        }
        if (item == ItemRegistry.SKILL_BOOK) {
            UmapyoiCreativeGroup.fillSkillBook(output);
            return;
        }
        output.m_246326_((ItemLike)item.get());
    })).m_257652_());
    public static final RegistryObject<CreativeModeTab> UMAPYOI_BLANK_SOULS = CREATIVE_MODE_TABS.register("umapyoi_blank_souls", () -> CreativeModeTab.builder().m_257737_(() -> ((Item)((Item)ItemRegistry.BLANK_UMA_SOUL.get())).m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.umapyoi.blank_souls")).m_257501_((features, output) -> ItemRegistry.ITEMS.getEntries().forEach(item -> {
        if (item == ItemRegistry.BLANK_UMA_SOUL) {
            UmapyoiCreativeGroup.fillBlankSoul(features, output);
            return;
        }
    })).m_257652_());
    public static final RegistryObject<CreativeModeTab> UMAPYOI_SOULS = CREATIVE_MODE_TABS.register("umapyoi_souls", () -> CreativeModeTab.builder().m_257737_(() -> ((Item)((Item)ItemRegistry.UMA_SOUL_DISPLAY.get())).m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.umapyoi.souls")).m_257501_((features, output) -> ItemRegistry.ITEMS.getEntries().forEach(item -> {
        if (item == ItemRegistry.UMA_SOUL) {
            UmapyoiCreativeGroup.fillUmaSoul(features, output);
            return;
        }
    })).m_257652_());
    public static final RegistryObject<CreativeModeTab> UMAPYOI_CARDS = CREATIVE_MODE_TABS.register("umapyoi_cards", () -> CreativeModeTab.builder().m_257737_(() -> ((Item)((Item)ItemRegistry.SUPPORT_CARD.get())).m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.umapyoi.cards")).m_257501_((features, output) -> ItemRegistry.ITEMS.getEntries().forEach(item -> {
        if (item == ItemRegistry.SUPPORT_CARD) {
            UmapyoiCreativeGroup.fillSupportCard(features, output);
            return;
        }
    })).m_257652_());

    private static void fillFactorContainer(CreativeModeTab.Output output) {
        for (UmaFactor factor : UmaFactorRegistry.REGISTRY.get().getValues()) {
            if (factor == UmaFactorRegistry.SKILL_FACTOR.get() || factor.getFactorType() == FactorType.UNIQUE) continue;
            ArrayList stackList = Lists.newArrayList((Object[])new UmaFactorStack[]{new UmaFactorStack(factor, 1)});
            ItemStack result = ((Item)ItemRegistry.UMA_FACTOR_ITEM.get()).m_7968_();
            result.m_41784_().m_128359_("name", "umapyoi:common_uma");
            result.m_41784_().m_128365_("factors", (Tag)UmaFactorUtils.serializeNBT(stackList));
            output.m_246342_(result);
        }
    }

    private static void fillUmaSoul(CreativeModeTab.ItemDisplayParameters features, CreativeModeTab.Output output) {
        UmaSoulItem.sortedUmaDataList(features.f_268485_()).forEach(entry -> {
            ItemStack initUmaSoul = UmaSoulUtils.initUmaSoul(((Item)ItemRegistry.UMA_SOUL.get()).m_7968_(), entry.m_205785_().m_135782_(), (UmaData)entry.m_203334_());
            UmaSoulUtils.setPhysique(initUmaSoul, 5);
            output.m_246342_(initUmaSoul);
        });
    }

    private static void fillCostume(CreativeModeTab.ItemDisplayParameters features, CreativeModeTab.Output output) {
        UmaCostumeItem.sortedCosmeticDataList(features.f_268485_()).forEach(entry -> {
            ItemStack result = ((Item)ItemRegistry.UMA_COSTUME.get()).m_7968_();
            result.m_41784_().m_128359_("cosmetic", entry.m_205785_().m_135782_().toString());
            output.m_246342_(result);
        });
    }

    private static void fillBlankSoul(CreativeModeTab.ItemDisplayParameters features, CreativeModeTab.Output output) {
        UmaSoulItem.sortedUmaDataList(features.f_268485_()).forEach(entry -> {
            ItemStack result = FadedUmaSoulItem.genUmaSoul(entry.m_205785_().m_135782_().toString(), (UmaData)entry.m_203334_());
            output.m_246342_(result);
        });
    }

    private static void fillSupportCard(CreativeModeTab.ItemDisplayParameters features, CreativeModeTab.Output output) {
        SupportCardItem.sortedCardDataList(features.f_268485_()).forEach(card -> {
            if (card.m_205785_().m_135782_().equals((Object)new ResourceLocation("umapyoi", "blank_card"))) {
                return;
            }
            ItemStack result = ((Item)ItemRegistry.SUPPORT_CARD.get()).m_7968_();
            result.m_41784_().m_128359_("support_card", card.m_205785_().m_135782_().toString());
            result.m_41784_().m_128359_("ranking", ((SupportCard)card.m_203334_()).getGachaRanking().name().toLowerCase());
            output.m_246342_(result);
        });
    }

    private static void fillSkillBook(CreativeModeTab.Output output) {
        for (ResourceLocation skill : UmaSkillRegistry.REGISTRY.get().getKeys()) {
            ItemStack result = ((Item)ItemRegistry.SKILL_BOOK.get()).m_7968_();
            result.m_41784_().m_128359_("skill", skill.toString());
            output.m_246342_(result);
        }
    }
}

