/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;

public class TargetSelector {
    public static final TargetingConditions areaTarget = TargetingConditions.m_148352_().m_26883_(12.0);

    public static List<Entity> getExtinguishableEntitiesWithinAABB(LivingEntity attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);
        AABB aabb = TargetSelector.getResolvedAxisAligned(attacker.m_20191_(), attacker.m_20154_(), reach);
        Level world = attacker.m_9236_();
        return world.m_45976_(PrimedTnt.class, aabb).stream().filter(e -> e.m_20280_((Entity)attacker) < reach * reach).collect(Collectors.toList());
    }

    public static List<Entity> getTargettableEntitiesWithinAABB(Level world, LivingEntity attacker) {
        return TargetSelector.getTargettableEntitiesWithinAABB(world, attacker, TargetSelector.getResolvedAxisAligned(attacker.m_20191_(), attacker.m_20154_(), TargetSelector.getResolvedReach(attacker)));
    }

    public static List<Entity> getTargettableEntitiesWithinAABB(Level world, LivingEntity attacker, AABB aabb) {
        double reach = TargetSelector.getResolvedReach(attacker);
        return TargetSelector.getTargettableEntitiesWithinAABB(world, attacker, aabb, reach);
    }

    public static List<Entity> getReflectableEntitiesWithinAABB(LivingEntity attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);
        AABB aabb = TargetSelector.getResolvedAxisAligned(attacker.m_20191_(), attacker.m_20154_(), reach);
        Level world = attacker.m_9236_();
        return Stream.of(world.m_45976_(Projectile.class, aabb).stream().filter(e -> e.m_19749_() == null || e.m_19749_() != attacker)).flatMap(s -> s).filter(e -> e.m_20280_((Entity)attacker) < reach * reach).collect(Collectors.toList());
    }

    public static List<Entity> getTargettableEntitiesWithinAABB(Level world, LivingEntity attacker, AABB aabb, double reach) {
        ArrayList list1 = Lists.newArrayList();
        list1.addAll(TargetSelector.getReflectableEntitiesWithinAABB(attacker));
        list1.addAll(TargetSelector.getExtinguishableEntitiesWithinAABB(attacker));
        list1.addAll(world.m_6443_(LivingEntity.class, aabb.m_82400_(5.0), e -> e.isMultipartEntity()).stream().flatMap(e -> e.isMultipartEntity() ? Stream.of(e.getParts()) : Stream.of(e)).filter(t -> {
            PartEntity part;
            Entity patt4341$temp;
            boolean result = false;
            AttackablePredicate check = new AttackablePredicate();
            if (t instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)t;
                result = check.test(living);
            } else if (t instanceof PartEntity && (patt4341$temp = (part = (PartEntity)t).getParent()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt4341$temp;
                result = check.test(living) && part.m_20280_((Entity)attacker) < reach * reach;
            }
            return result;
        }).collect(Collectors.toList()));
        TargetingConditions predicate = areaTarget.m_26883_(reach);
        list1.addAll(world.m_45976_(LivingEntity.class, aabb).stream().flatMap(e -> e.isMultipartEntity() ? Stream.of(e.getParts()) : Stream.of(e)).filter(t -> {
            PartEntity part;
            Entity patt4973$temp;
            boolean result = false;
            if (t instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)t;
                result = predicate.m_26885_(attacker, living);
            } else if (t instanceof PartEntity && (patt4973$temp = (part = (PartEntity)t).getParent()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)patt4973$temp;
                result = predicate.m_26885_(attacker, living) && part.m_20280_((Entity)attacker) < reach * reach;
            }
            return result;
        }).collect(Collectors.toList()));
        return list1;
    }

    public static AABB getResolvedAxisAligned(AABB bb, Vec3 dir, double reach) {
        double padding = 1.0;
        bb = dir == Vec3.f_82478_ ? bb.m_82400_(reach * 2.0) : bb.m_82383_(dir.m_82490_(reach * 0.5)).m_82400_(reach);
        bb = bb.m_82400_(1.0);
        return bb;
    }

    public static double getResolvedReach(LivingEntity user) {
        double reach = 4.0;
        AttributeInstance attrib = user.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        if (attrib != null) {
            reach = attrib.m_22135_() - 1.0;
        }
        return reach;
    }

    public static class AttackablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity livingentity) {
            if (livingentity instanceof ArmorStand) {
                return ((ArmorStand)livingentity).m_31677_();
            }
            if (livingentity.m_146862_(entity -> entity instanceof Player)) {
                return false;
            }
            if (livingentity.m_142038_()) {
                return true;
            }
            if (livingentity.m_5647_() != null) {
                return true;
            }
            return true;
        }
    }
}

