/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import cn.mcmod_mmf.mmlib.block.entity.SyncedBlockEntity;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.block.entity.Gachable;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.inventory.CommonItemHandler;
import net.tracen.umapyoi.item.FadedUmaSoulItem;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.GachaUtils;
import org.jetbrains.annotations.NotNull;

public class SilverUmaPedestalBlockEntity
extends SyncedBlockEntity
implements Gachable {
    public static final int MAX_PROCESS_TIME = 200;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new CommonItemHandler((IItemHandler)this.inventory, Direction.UP, 1, 0));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new CommonItemHandler((IItemHandler)this.inventory, Direction.DOWN, 1, 0));
    protected final ContainerData tileData = this.createIntArray();
    private int recipeTime;
    private int animationTime;

    public int getProcessTime() {
        return this.recipeTime;
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public SilverUmaPedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SILVER_UMA_PEDESTAL.get(), pos, state);
    }

    public static void workingTick(Level level, BlockPos pos, BlockState state, SilverUmaPedestalBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        boolean didInventoryChange = false;
        if (blockEntity.canWork()) {
            didInventoryChange = blockEntity.processRecipe();
        } else {
            blockEntity.recipeTime = 0;
        }
        if (didInventoryChange) {
            blockEntity.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, SilverUmaPedestalBlockEntity blockEntity) {
        ++blockEntity.animationTime;
        if (blockEntity.canWork()) {
            ClientUtils.addSummonParticle(level, pos);
        }
        blockEntity.animationTime %= 360;
    }

    private boolean processRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.recipeTime;
        if (this.recipeTime < 200) {
            return false;
        }
        this.recipeTime = 0;
        ItemStack resultStack = this.getResultItem();
        this.inventory.setStackInSlot(0, resultStack.m_41777_());
        this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    private ItemStack getResultItem() {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        RandomSource rand = this.m_58904_().m_213780_();
        Registry<UmaData> registry = UmapyoiAPI.getUmaDataRegistry(this.m_58904_());
        @NotNull Collection keys = registry.m_6566_().stream().filter(this.getFilter(this.m_58904_(), this.getStoredItem())).collect(Collectors.toCollection(Lists::newArrayList));
        ResourceLocation holder = keys.stream().skip(keys.isEmpty() ? 0L : (long)rand.m_188503_(keys.size())).findFirst().orElse(UmaData.DEFAULT_UMA_ID);
        ItemStack result = FadedUmaSoulItem.genUmaSoul(holder.toString(), (UmaData)registry.m_7745_(holder));
        return result;
    }

    private boolean canWork() {
        return !this.getStoredItem().m_41619_() && this.getStoredItem().m_204117_(UmapyoiItemTags.UMA_TICKET) && !this.getStoredItem().m_204117_(UmapyoiItemTags.SSR_UMA_TICKET);
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().m_41620_(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        drops.add((Object)this.inventory.getStackInSlot(0));
        return drops;
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeTime = compound.m_128451_("RecipeTime");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("RecipeTime", this.recipeTime);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                SilverUmaPedestalBlockEntity.this.inventoryChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                switch (index) {
                    case 0: {
                        return SilverUmaPedestalBlockEntity.this.recipeTime;
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        SilverUmaPedestalBlockEntity.this.recipeTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    @Override
    public Predicate<? super ResourceLocation> getFilter(Level level, ItemStack input) {
        return resloc -> {
            if (!input.m_41784_().m_128461_("name").isBlank()) {
                return resloc.equals((Object)ResourceLocation.m_135820_((String)input.m_41784_().m_128461_("name")));
            }
            if (input.m_204117_(UmapyoiItemTags.SR_UMA_TICKET)) {
                return ((UmaData)UmapyoiAPI.getUmaDataRegistry(level).m_7745_(resloc)).getGachaRanking() == GachaRanking.SR;
            }
            if (input.m_204117_(UmapyoiItemTags.COMMON_GACHA_ITEM)) {
                return ((UmaData)UmapyoiAPI.getUmaDataRegistry(level).m_7745_(resloc)).getGachaRanking() == GachaRanking.R;
            }
            boolean cfgFlag = GachaUtils.checkGachaConfig();
            int ssrHit = cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SSR.get() : 10;
            int gacha_roll = level.m_213780_().m_188503_(cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SUM.get() : 100);
            int srHit = ssrHit + (cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SR.get() : 20);
            return ((UmaData)UmapyoiAPI.getUmaDataRegistry(level).m_7745_(resloc)).getGachaRanking() == (gacha_roll < srHit ? GachaRanking.SR : GachaRanking.R);
        };
    }
}

