/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import cn.mcmod_mmf.mmlib.block.entity.SyncedBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.item.ItemRegistry;

public class UmaStatueBlockEntity
extends SyncedBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> this.inventory);

    public UmaStatueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.UMA_STATUES.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && itemStack.m_150930_((Item)ItemRegistry.UMA_SOUL.get())) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().m_41620_(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                UmaStatueBlockEntity.this.inventoryChanged();
            }
        };
    }

    public AABB getRenderBoundingBox() {
        return AABB.m_165882_((Vec3)this.m_58899_().m_252807_().m_82520_(0.0, 1.0, 0.0), (double)1.0, (double)3.0, (double)1.0);
    }
}

