/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.renderer;

import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.tracen.umapyoi.client.model.UmaPlayerModel;
import net.tracen.umapyoi.data.tag.UmapyoiUmaDataTags;
import net.tracen.umapyoi.events.client.RenderingUmaSoulEvent;
import net.tracen.umapyoi.item.UmaCostumeItem;
import net.tracen.umapyoi.item.UmaSuitItem;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class UmaSoulRenderer
implements ICurioRenderer {
    private final UmaPlayerModel<LivingEntity> baseModel = new UmaPlayerModel();

    public UmaPlayerModel<LivingEntity> getBaseModel() {
        return this.baseModel;
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!slotContext.visible()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        if (!(entity instanceof ArmorStand) && !slotContext.identifier().equalsIgnoreCase("uma_soul")) {
            return;
        }
        if (entity.m_20145_() && !entity.m_5833_()) {
            return;
        }
        ResourceLocation renderTarget = UmaSoulRenderer.getRenderTarget(stack, entity);
        BedrockModelPOJO pojo = ClientUtil.getModelPOJO((ResourceLocation)renderTarget);
        if (this.baseModel.needRefresh(pojo)) {
            this.baseModel.loadModel(pojo);
        }
        VertexConsumer vertexConsumer = renderTypeBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)ClientUtils.getTexture(renderTarget)));
        this.baseModel.setModelProperties(entity);
        this.baseModel.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderingUmaSoulEvent.Pre(entity, this.baseModel, partialTicks, matrixStack, renderTypeBuffer, light))) {
            return;
        }
        EntityModel entityModel = renderLayerParent.m_7200_();
        if (entityModel instanceof HumanoidModel) {
            HumanoidModel entityModel2 = (HumanoidModel)entityModel;
            this.baseModel.copyAnim(this.baseModel.head, entityModel2.f_102808_);
            this.baseModel.copyAnim(this.baseModel.body, entityModel2.f_102810_);
            this.baseModel.copyAnim(this.baseModel.leftArm, entityModel2.f_102812_);
            this.baseModel.copyAnim(this.baseModel.leftLeg, entityModel2.f_102814_);
            this.baseModel.copyAnim(this.baseModel.rightArm, entityModel2.f_102811_);
            this.baseModel.copyAnim(this.baseModel.rightLeg, entityModel2.f_102813_);
        }
        this.baseModel.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.baseModel.m_7695_(matrixStack, vertexConsumer, light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        if (this.baseModel.isEmissive()) {
            VertexConsumer emissiveConsumer = renderTypeBuffer.m_6299_(RenderType.m_234338_((ResourceLocation)ClientUtils.getEmissiveTexture(renderTarget)));
            this.baseModel.renderEmissiveParts(matrixStack, emissiveConsumer, light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderingUmaSoulEvent.Post(entity, this.baseModel, partialTicks, matrixStack, renderTypeBuffer, light));
    }

    public static ResourceLocation getRenderTarget(ItemStack stack, LivingEntity entity) {
        ICurioStacksHandler stacksHandler;
        IDynamicStackHandler stackHandler;
        ICuriosItemHandler itemHandler;
        boolean suit_flag = false;
        boolean alter_flag = false;
        if (CuriosApi.getCuriosInventory((LivingEntity)entity).isPresent() && (itemHandler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).orElse(null)).getStacksHandler("uma_suit").isPresent() && (stackHandler = (stacksHandler = (ICurioStacksHandler)itemHandler.getStacksHandler("uma_suit").orElse(null)).getStacks()).getSlots() > 0 && (stackHandler.getStackInSlot(0).m_41720_() instanceof UmaSuitItem || stackHandler.getStackInSlot(0).m_41720_() instanceof UmaCostumeItem)) {
            suit_flag = (Boolean)stacksHandler.getRenders().get(0);
            alter_flag = ((Holder.Reference)ClientUtils.getClientUmaDataRegistry().m_203636_(ResourceKey.m_135785_(UmaData.REGISTRY_KEY, (ResourceLocation)UmaSoulUtils.getName(stack))).get()).m_203656_(UmapyoiUmaDataTags.ALTER_MODEL);
        }
        ResourceLocation renderTarget = suit_flag ? UmaSoulRenderer.getSuitTarget(stack, alter_flag) : UmaSoulUtils.getName(stack);
        return renderTarget;
    }

    private static ResourceLocation getSuitTarget(ItemStack stack, boolean alter) {
        ResourceLocation identifier = ((UmaData)ClientUtils.getClientUmaDataRegistry().m_7745_(UmaSoulUtils.getName(stack))).getIdentifier();
        if (alter) {
            identifier = new ResourceLocation(identifier.m_135827_(), identifier.m_135815_() + "_alter");
        }
        return identifier;
    }
}

