/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.container.UmaSelectMenu;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.network.EmptyResultPacket;
import net.tracen.umapyoi.network.NetPacketHandler;
import net.tracen.umapyoi.network.SetupResultPacket;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaSelectScreen
extends AbstractContainerScreen<UmaSelectMenu>
implements ContainerListener {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("umapyoi", "textures/gui/select_test.png");
    private EditBox searchBox;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 49;
    private static final int RECIPES_Y = 30;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private int selectIndex;
    private boolean displayRecipes;
    private String name;

    public UmaSelectScreen(UmaSelectMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97727_ = 186;
        this.selectIndex = -1;
        this.name = "";
        pMenu.registerUpdateListener(this::containerChanged);
    }

    public void m_88315_(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        RenderSystem.disableBlend();
        this.renderFg(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pPoseStack, pMouseX, pMouseY);
    }

    public void m_181908_() {
        super.m_181908_();
        this.searchBox.m_94120_();
    }

    public void renderFg(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.searchBox.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    protected void m_280003_(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        pPoseStack.m_280430_(this.f_96547_, this.f_96539_, this.f_97726_ / 2 - this.f_96547_.m_92724_(this.f_96539_.m_7532_()) / 2, this.f_97729_ - 3, 0xFFFFFF);
        pPoseStack.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ + 20, 0x404040, false);
    }

    protected void subInit() {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.searchBox = new EditBox(this.f_96547_, i + 42, j + 17, 90, 12, (Component)Component.m_237115_((String)"container.uma_select"));
        this.searchBox.m_94190_(false);
        this.searchBox.m_94202_(-1);
        this.searchBox.m_94205_(-1);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94199_(50);
        this.searchBox.m_94151_(this::onNameChanged);
        this.searchBox.m_94144_("");
        this.m_7787_((GuiEventListener)this.searchBox);
        this.m_264313_((GuiEventListener)this.searchBox);
        this.searchBox.m_94186_(false);
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.searchBox.m_94155_();
        this.m_6575_(pMinecraft, pWidth, pHeight);
        this.searchBox.m_94144_(s);
        this.searchBox.m_94186_(this.hasRequestItems());
    }

    protected void m_7856_() {
        super.m_7856_();
        this.subInit();
        ((UmaSelectMenu)this.f_97732_).m_38893_(this);
    }

    public void m_7861_() {
        super.m_7861_();
        ((UmaSelectMenu)this.f_97732_).m_38943_(this);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return !this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.searchBox.m_94204_() ? super.m_7933_(pKeyCode, pScanCode, pModifiers) : true;
    }

    private void onNameChanged(String name) {
        boolean hasItems = this.hasRequestItems();
        if (!hasItems) {
            return;
        }
        if (name.length() <= 50 && !this.name.equalsIgnoreCase(name)) {
            this.name = name;
            this.selectIndex = -1;
            NetPacketHandler.INSTANCE.sendToServer((Object)new EmptyResultPacket());
        }
    }

    public boolean hasRequestItems() {
        return ((UmaSelectMenu)this.f_97732_).m_38853_(0).m_6657_() && ((UmaSelectMenu)this.f_97732_).m_38853_(1).m_6657_();
    }

    protected void m_7286_(GuiGraphics pPoseStack, float pPartialTick, int pX, int pY) {
        this.m_280273_(pPoseStack);
        int i = this.f_97735_;
        int j = this.f_97736_;
        pPoseStack.m_280218_(BACKGROUND_TEXTURE, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(41.0f * this.scrollOffs);
        pPoseStack.m_280218_(BACKGROUND_TEXTURE, i + 116, j + 31 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 49;
        int i1 = this.f_97736_ + 30;
        int j1 = this.startIndex + 12;
        this.renderButtons(pPoseStack, pX, pY, l, i1, j1);
        this.renderRecipes(pPoseStack, l, i1, j1);
    }

    protected void m_280072_(GuiGraphics pPoseStack, int pX, int pY) {
        super.m_280072_(pPoseStack, pX, pY);
        if (this.displayRecipes) {
            int i = this.f_97735_ + 49;
            int j = this.f_97736_ + 30;
            int k = this.startIndex + 12;
            List<ResourceLocation> list = this.getResults();
            for (int l = this.startIndex; l < k && l < this.getResults().size(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (pX < j1 || pX >= j1 + 16 || pY < k1 || pY >= k1 + 18) continue;
                pPoseStack.m_280153_(this.f_96547_, this.getResultItem(list.get(l)), pX, pY);
            }
        }
    }

    private void renderButtons(GuiGraphics pPoseStack, int pMouseX, int pMouseY, int pX, int pY, int pLastVisibleElementIndex) {
        if (this.displayRecipes) {
            for (int i = this.startIndex; i < pLastVisibleElementIndex && i < this.getResults().size(); ++i) {
                int j = i - this.startIndex;
                int k = pX + j % 4 * 16;
                int l = j / 4;
                int i1 = pY + l * 18 + 2;
                int j1 = 15;
                if (i == this.selectIndex) {
                    j1 += 18;
                } else if (pMouseX >= k && pMouseY >= i1 && pMouseX < k + 16 && pMouseY < i1 + 18) {
                    j1 += 36;
                }
                pPoseStack.m_280218_(BACKGROUND_TEXTURE, k, i1 - 1, 176, j1, 16, 18);
            }
        }
    }

    private void renderRecipes(GuiGraphics pPoseStack, int pLeft, int pTop, int pRecipeIndexOffsetMax) {
        if (this.displayRecipes) {
            List<ResourceLocation> list = this.getResults();
            for (int i = this.startIndex; i < pRecipeIndexOffsetMax && i < this.getResults().size(); ++i) {
                int j = i - this.startIndex;
                int k = pLeft + j % 4 * 16;
                int l = j / 4;
                int i1 = pTop + l * 18 + 2;
                pPoseStack.m_280480_(this.getResultItem(list.get(i)), k, i1);
            }
        }
    }

    public List<ResourceLocation> getResults() {
        List<ResourceLocation> list = ((UmaSelectMenu)this.f_97732_).getRecipes();
        ArrayList result = list.stream().filter(this.getFilter(((UmaSelectMenu)this.f_97732_).m_38853_(0).m_7993_())).sorted(UmaSelectMenu.SelectComparator.INSTANCE).collect(Collectors.toCollection(Lists::newArrayList));
        return result;
    }

    public Predicate<? super ResourceLocation> getFilter(ItemStack input) {
        return resloc -> {
            boolean rankingCheck;
            if (input.m_204117_(UmapyoiItemTags.CARD_TICKET)) {
                boolean rankingCheck2;
                SupportCard card = (SupportCard)ClientUtils.getClientSupportCardRegistry().m_7745_(resloc);
                boolean ssrRanking = input.m_204117_(UmapyoiItemTags.SSR_CARD_TICKET);
                boolean srRanking = input.m_204117_(UmapyoiItemTags.SR_CARD_TICKET);
                boolean bl = ssrRanking ? card.getGachaRanking() == GachaRanking.SSR : (srRanking ? card.getGachaRanking() == GachaRanking.SR : (rankingCheck2 = card.getGachaRanking() == GachaRanking.R));
                if (this.getName().isBlank()) {
                    return rankingCheck2;
                }
                String s = this.getName().toLowerCase(Locale.ROOT);
                if (s.startsWith("@")) {
                    s = s.substring(1);
                    return card.getSupporters().contains(ResourceLocation.m_135820_((String)s)) && rankingCheck2;
                }
                MutableComponent localized = Component.m_237115_((String)(Util.m_137492_((String)"support_card", (ResourceLocation)resloc) + ".name"));
                boolean nameCheck = resloc.toString().contains(s) || ChatFormatting.m_126649_((String)localized.getString()).contains(s);
                return nameCheck && rankingCheck2;
            }
            UmaData uma = (UmaData)ClientUtils.getClientUmaDataRegistry().m_7745_(resloc);
            boolean ssrRanking = input.m_204117_(UmapyoiItemTags.SSR_UMA_TICKET);
            boolean srRanking = input.m_204117_(UmapyoiItemTags.SR_UMA_TICKET);
            boolean bl = ssrRanking ? uma.getGachaRanking() == GachaRanking.SSR : (srRanking ? uma.getGachaRanking() == GachaRanking.SR : (rankingCheck = uma.getGachaRanking() == GachaRanking.R));
            if (this.getName().isBlank()) {
                return rankingCheck;
            }
            String s = this.getName().toLowerCase(Locale.ROOT);
            if (s.startsWith("@")) {
                s = s.substring(1);
                return uma.getIdentifier().equals((Object)ResourceLocation.m_135820_((String)s)) && rankingCheck;
            }
            MutableComponent localized = Component.m_237115_((String)Util.m_137492_((String)"umadata", (ResourceLocation)resloc));
            boolean nameCheck = resloc.toString().contains(s) || ChatFormatting.m_126649_((String)localized.getString()).contains(s);
            return nameCheck && rankingCheck;
        };
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private ItemStack getResultItem(ResourceLocation name) {
        if (((UmaSelectMenu)this.m_6262_()).m_38853_(0).m_7993_().m_204117_(UmapyoiItemTags.CARD_TICKET)) {
            Registry<SupportCard> registry = ClientUtils.getClientSupportCardRegistry();
            ItemStack result = ((Item)ItemRegistry.SUPPORT_CARD.get()).m_7968_();
            result.m_41784_().m_128359_("support_card", name.toString());
            result.m_41784_().m_128359_("ranking", ((SupportCard)registry.m_7745_(name)).getGachaRanking().name().toLowerCase());
            result.m_41784_().m_128405_("maxDamage", ((SupportCard)registry.m_7745_(name)).getMaxDamage());
            return result;
        }
        Registry<UmaData> registry = ClientUtils.getClientUmaDataRegistry();
        ItemStack initUmaSoul = UmaSoulUtils.initUmaSoul(((Item)ItemRegistry.UMA_SOUL.get()).m_7968_(), name, (UmaData)registry.m_7745_(name));
        UmaSoulUtils.setPhysique(initUmaSoul, 5);
        return initUmaSoul;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.f_97735_ + 49;
            int j = this.f_97736_ + 30;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                if (l >= this.getResults().size()) {
                    return super.m_6375_(pMouseX, pMouseY, pButton);
                }
                int i1 = l - this.startIndex;
                double d0 = pMouseX - (double)(i + i1 % 4 * 16);
                double d1 = pMouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.selectIndex = l;
                NetPacketHandler.INSTANCE.sendToServer((Object)new SetupResultPacket(this.getResults().get(this.getSelectIndex()).toString()));
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (pMouseX >= (double)i && pMouseX < (double)(i + 12) && pMouseY >= (double)j && pMouseY < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 30;
            int j = i + 54;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pDelta / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.getResults().size() > 12;
    }

    protected int getOffscreenRows() {
        return (this.getResults().size() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        boolean bl = this.displayRecipes = ((UmaSelectMenu)this.f_97732_).hasInputItem() && this.getResults().size() > 0;
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
            this.selectIndex = -1;
        }
    }

    public void m_7934_(AbstractContainerMenu pContainerToSend, int pDataSlotIndex, ItemStack pStack) {
        boolean hasItems;
        boolean bl = hasItems = pContainerToSend.m_38853_(0).m_6657_() && pContainerToSend.m_38853_(1).m_6657_();
        if (!hasItems) {
            this.selectIndex = -1;
        }
        this.searchBox.m_94144_(!hasItems ? "" : this.searchBox.m_94155_());
        this.searchBox.m_94186_(hasItems);
        this.m_7522_((GuiEventListener)this.searchBox);
    }

    public void m_142153_(AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
    }

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public void setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
    }
}

