/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.SupportCardItem;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.utils.GachaRanking;

public class DisassemblyBlockMenu
extends AbstractContainerMenu {
    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Container inputSlots = new SimpleContainer(1){

        public int m_6643_() {
            return 1;
        }

        public void m_6596_() {
            super.m_6596_();
            DisassemblyBlockMenu.this.m_6199_((Container)this);
        }
    };
    protected final ContainerLevelAccess access;
    protected final Player player;

    protected boolean mayPickup(Player pPlayer, boolean pHasStack) {
        return this.hasResult();
    }

    protected boolean hasResult() {
        ItemStack inputSoul = this.inputSlots.m_8020_(0);
        return inputSoul.m_41720_() instanceof UmaSoulItem || inputSoul.m_41720_() instanceof SupportCardItem;
    }

    protected void onTake(Player player, ItemStack resultStack) {
        resultStack.m_41678_(player.m_9236_(), player, resultStack.m_41613_());
        this.resultSlots.m_58395_(player, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.access.m_39292_((level, pos) -> player.m_5496_(SoundEvents.f_144242_, 1.0f, 1.0f));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.m_8020_(0));
    }

    private void shrinkStackInSlot(int pIndex) {
        ItemStack itemstack = this.inputSlots.m_8020_(pIndex);
        itemstack.m_41774_(1);
        this.inputSlots.m_6836_(pIndex, itemstack);
    }

    protected boolean isValidBlock(BlockState pState) {
        return pState.m_60713_((Block)BlockRegistry.DISASSEMBLY_BLOCK.get());
    }

    public DisassemblyBlockMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public DisassemblyBlockMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        this((MenuType)ContainerRegistry.DISASSEMBLY_BLOCK.get(), pContainerId, pPlayerInventory, pAccess);
    }

    public DisassemblyBlockMenu(@Nullable MenuType<?> pType, int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super(pType, pContainerId);
        this.access = pAccess;
        this.player = pPlayerInventory.f_35978_;
        this.m_38897_(new Slot(this.inputSlots, 0, 44, 59));
        this.m_38897_(new Slot((Container)this.resultSlots, 1, 116, 59){

            public boolean m_5857_(ItemStack p_39818_) {
                return false;
            }

            public boolean m_8010_(Player p_39813_) {
                return DisassemblyBlockMenu.this.mayPickup(p_39813_, this.m_6657_());
            }

            public void m_142406_(Player p_150604_, ItemStack p_150605_) {
                DisassemblyBlockMenu.this.onTake(p_150604_, p_150605_);
                p_150604_.m_7408_(p_150605_, 0);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 152));
        }
    }

    public void createResult() {
        if (!this.hasResult()) {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.resultSlots.m_6836_(0, this.getResultItem());
        }
    }

    private ItemStack getResultItem() {
        ItemStack inputSoul = this.inputSlots.m_8020_(0).m_41777_();
        boolean isSupport = inputSoul.m_41720_() instanceof SupportContainer;
        if (!(inputSoul.m_41720_() instanceof UmaSoulItem) && !isSupport) {
            return ItemStack.f_41583_;
        }
        if (!inputSoul.m_41784_().m_128441_("ranking")) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ItemStack.f_41583_;
        GachaRanking ranking = GachaRanking.valueOf(inputSoul.m_41784_().m_128461_("ranking").toUpperCase());
        switch (ranking) {
            case SR: {
                result = isSupport ? new ItemStack((ItemLike)ItemRegistry.HORSESHOE_GOLD.get()) : new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GOLD.get());
                break;
            }
            case SSR: {
                result = isSupport ? new ItemStack((ItemLike)ItemRegistry.HORSESHOE_RAINBOW.get()) : new ItemStack((ItemLike)ItemRegistry.CRYSTAL_RAINBOW.get());
                break;
            }
            default: {
                result = isSupport ? new ItemStack((ItemLike)ItemRegistry.HORSESHOE_SILVER.get()) : new ItemStack((ItemLike)ItemRegistry.CRYSTAL_SILVER.get());
            }
        }
        return result;
    }

    public void m_6199_(Container pInventory) {
        super.m_6199_(pInventory);
        if (pInventory == this.inputSlots) {
            this.createResult();
        }
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, this.inputSlots));
    }

    public boolean m_6875_(Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> !this.isValidBlock(level.m_8055_(pos)) ? false : pPlayer.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            int i;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 1) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex != 0 ? pIndex >= 2 && pIndex < 38 && !this.m_38903_(itemstack1, i = 0, 1, false) : !this.m_38903_(itemstack1, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }
}

