/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.UmaFactorRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.SkillFactor;
import net.tracen.umapyoi.registry.factors.StatusFactor;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.utils.ResultRankingUtils;
import net.tracen.umapyoi.utils.UmaFactorUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import org.jetbrains.annotations.NotNull;

public class RetireRegisterMenu
extends AbstractContainerMenu {
    private final DataSlot factorSeed = DataSlot.m_39401_();
    private final Random rand = new Random();
    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Container inputSlots = new SimpleContainer(1){

        public int m_6643_() {
            return 1;
        }

        public void m_6596_() {
            super.m_6596_();
            RetireRegisterMenu.this.m_6199_((Container)this);
        }
    };
    protected final ContainerLevelAccess access;
    protected final Player player;

    protected boolean mayPickup(Player pPlayer, boolean pHasStack) {
        return this.hasResult();
    }

    protected boolean hasResult() {
        ItemStack inputSoul = this.inputSlots.m_8020_(0);
        if (inputSoul.m_41720_() instanceof UmaSoulItem) {
            return UmaSoulUtils.getGrowth(inputSoul) == Growth.TRAINED;
        }
        return false;
    }

    protected void onTake(Player player, ItemStack resultStack) {
        resultStack.m_41678_(player.m_9236_(), player, resultStack.m_41613_());
        this.resultSlots.m_58395_(player, this.getRelevantItems());
        ItemStack inputSoul = this.inputSlots.m_8020_(0).m_41777_();
        if (inputSoul.m_41720_() instanceof UmaSoulItem) {
            UmaSoulUtils.setGrowth(inputSoul, Growth.RETIRED);
            this.inputSlots.m_6836_(0, inputSoul);
            this.access.m_39292_((level, pos) -> player.m_5496_(SoundEvents.f_12275_, 1.0f, 1.0f));
        }
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.m_8020_(0));
    }

    protected boolean isValidBlock(BlockState pState) {
        return pState.m_60713_((Block)BlockRegistry.REGISTER_LECTERN.get());
    }

    public RetireRegisterMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public RetireRegisterMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        this((MenuType)ContainerRegistry.RETIRE_REGISTER.get(), pContainerId, pPlayerInventory, pAccess);
    }

    public RetireRegisterMenu(@Nullable MenuType<?> pType, int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super(pType, pContainerId);
        this.access = pAccess;
        this.player = pPlayerInventory.f_35978_;
        this.m_38897_(new Slot(this.inputSlots, 0, 44, 59));
        this.m_38897_(new Slot((Container)this.resultSlots, 1, 116, 59){

            public boolean m_5857_(ItemStack p_39818_) {
                return false;
            }

            public boolean m_8010_(Player p_39813_) {
                return RetireRegisterMenu.this.mayPickup(p_39813_, this.m_6657_());
            }

            public void m_142406_(Player p_150604_, ItemStack p_150605_) {
                RetireRegisterMenu.this.onTake(p_150604_, p_150605_);
                p_150604_.m_7408_(p_150605_, 0);
                RetireRegisterMenu.this.factorSeed.m_6422_(p_150604_.m_36322_());
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 94 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 152));
        }
        this.m_38895_(this.factorSeed).m_6422_(this.player.m_36322_());
    }

    public void createResult() {
        if (!this.hasResult()) {
            this.resultSlots.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.resultSlots.m_6836_(0, this.getResultItem());
        }
    }

    private ItemStack getResultItem() {
        ItemStack result = ((Item)ItemRegistry.UMA_FACTOR_ITEM.get()).m_7968_();
        ItemStack inputSoul = this.inputSlots.m_8020_(0).m_41777_();
        if (!(inputSoul.m_41720_() instanceof UmaSoulItem)) {
            return ItemStack.f_41583_;
        }
        int ranking = ResultRankingUtils.getRanking(inputSoul);
        this.rand.setSeed(this.getFactorSeed().m_6501_());
        List<UmaFactorStack> stackList = this.createResultFactors(inputSoul, ranking);
        result.m_41784_().m_128359_("name", UmaSoulUtils.getName(inputSoul).toString());
        result.m_41784_().m_128365_("factors", (Tag)UmaFactorUtils.serializeNBT(stackList));
        return result;
    }

    public List<UmaFactorStack> createResultFactors(ItemStack inputSoul, int ranking) {
        @NotNull Stream<UmaFactor> status = UmaFactorRegistry.REGISTRY.get().getValues().stream().filter(fac -> fac.getFactorType() == FactorType.STATUS);
        long statusCount = UmaFactorRegistry.REGISTRY.get().getValues().stream().filter(fac -> fac.getFactorType() == FactorType.STATUS).count();
        StatusFactor statusFactor = (StatusFactor)status.skip(this.rand.nextLong(statusCount)).findFirst().orElse((UmaFactor)UmaFactorRegistry.SPEED_FACTOR.get());
        int statusProperty = UmaSoulUtils.getProperty(inputSoul)[statusFactor.getStatusType().getId()];
        int i = statusProperty > 18 ? statusFactor.getMaxLevel() + 1 : (statusProperty > 10 ? 3 : 2);
        UmaFactorStack statusFactorStack = new UmaFactorStack(statusFactor, this.rand.nextInt(i) + 1);
        Stream<UmaFactor> extraStatus = UmaFactorRegistry.REGISTRY.get().getValues().stream().filter(fac -> fac.getFactorType() == FactorType.EXTRASTATUS);
        long extraStatusCount = UmaFactorRegistry.REGISTRY.get().getValues().stream().filter(fac -> fac.getFactorType() == FactorType.EXTRASTATUS).count();
        UmaFactor extraStatusFactor = extraStatus.skip(this.rand.nextLong(extraStatusCount)).findFirst().orElse((UmaFactor)UmaFactorRegistry.PHYSIQUE_FACTOR.get());
        UmaFactorStack extraStatusFactorStack = new UmaFactorStack(extraStatusFactor, this.rand.nextInt(ranking > 18 ? statusFactor.getMaxLevel() : 2) + 1);
        UmaFactorStack uniqueFactor = new UmaFactorStack((UmaFactor)UmaFactorRegistry.UNIQUE_SKILL_FACTOR.get(), 1);
        uniqueFactor.getOrCreateTag().m_128359_("skill", UmaSoulUtils.getSkills(inputSoul).get(0).m_7916_());
        ArrayList stackList = Lists.newArrayList((Object[])new UmaFactorStack[]{statusFactorStack, extraStatusFactorStack, uniqueFactor});
        this.createOtherFactors(inputSoul, ranking, stackList);
        this.createSkillFactors(inputSoul, ranking, stackList);
        return stackList;
    }

    public void createSkillFactors(ItemStack inputSoul, int ranking, List<UmaFactorStack> stackList) {
        UmaSoulUtils.getSkills(inputSoul).stream().skip(1L).forEach(skillTag -> {
            String name = skillTag.m_7916_();
            ResourceLocation skill = ResourceLocation.m_135820_((String)name);
            if (skill != null && UmaSkillRegistry.REGISTRY.get().containsKey(skill)) {
                UmaSkill result = (UmaSkill)UmaSkillRegistry.REGISTRY.get().getValue(skill);
                if (!result.isInheritable()) {
                    return;
                }
                int skillLevel = this.rand.nextInt(ranking > 18 ? 6 : 4);
                if (skillLevel == 0) {
                    return;
                }
                UmaFactorStack skillFactor = new UmaFactorStack((UmaFactor)UmaFactorRegistry.SKILL_FACTOR.get(), skillLevel);
                skillFactor.getOrCreateTag().m_128359_("skill", name);
                stackList.add(skillFactor);
            }
        });
    }

    public void createOtherFactors(ItemStack inputSoul, int ranking, List<UmaFactorStack> stackList) {
        UmaFactorRegistry.REGISTRY.get().getValues().stream().filter(fac -> fac.getFactorType() == FactorType.OTHER && !(fac instanceof SkillFactor)).forEach(fac -> {
            int skillLevel = this.rand.nextInt(ranking > 19 ? fac.getMaxLevel() + 1 : fac.getMaxLevel() / 2 + 1);
            if (skillLevel == 0) {
                return;
            }
            UmaFactorStack skillFactor = new UmaFactorStack((UmaFactor)fac, skillLevel);
            stackList.add(skillFactor);
        });
    }

    public void m_6199_(Container pInventory) {
        super.m_6199_(pInventory);
        this.rand.setSeed(this.getFactorSeed().m_6501_());
        if (pInventory == this.inputSlots) {
            this.createResult();
        }
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, this.inputSlots));
    }

    public boolean m_6875_(Player pPlayer) {
        return (Boolean)this.access.m_39299_((level, pos) -> !this.isValidBlock(level.m_8055_(pos)) ? false : pPlayer.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            int i;
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 1) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex != 0 ? pIndex >= 2 && pIndex < 38 && !this.m_38903_(itemstack1, i = 0, 1, false) : !this.m_38903_(itemstack1, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }

    public DataSlot getFactorSeed() {
        return this.factorSeed;
    }
}

