/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.SkillBookItem;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.utils.UmaSkillUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class SkillLearningMenu
extends ItemCombinerMenu {
    public SkillLearningMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public SkillLearningMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super((MenuType)ContainerRegistry.SKILL_LEARNING_TABLE.get(), pContainerId, pPlayerInventory, pAccess);
    }

    protected boolean m_6560_(Player pPlayer, boolean pHasStack) {
        return this.hasResult();
    }

    private boolean hasResult() {
        ItemStack inputSoul = this.f_39769_.m_8020_(0);
        ItemStack inputSkill = this.f_39769_.m_8020_(1);
        if (this.isUmaSoul(inputSoul) && this.isSkillBook(inputSkill)) {
            ResourceLocation skillRL = ResourceLocation.m_135820_((String)inputSkill.m_41784_().m_128461_("skill"));
            if (UmaSkillRegistry.REGISTRY.get().containsKey(skillRL)) {
                ResourceLocation upperSkill = ((UmaSkill)UmaSkillRegistry.REGISTRY.get().getValue(skillRL)).getUpperSkill();
                if (upperSkill != null && UmaSkillUtils.hasLearnedSkill(inputSoul, upperSkill)) {
                    return false;
                }
                if (!UmaSoulUtils.hasEmptySkillSlot(inputSoul) && UmaSkillUtils.getLowerSkillIndex(inputSkill, skillRL) == -1) {
                    return false;
                }
                UmaSkill skill = (UmaSkill)UmaSkillRegistry.REGISTRY.get().getValue(skillRL);
                boolean result = UmaSkillUtils.hasLearnedSkill(inputSoul, skillRL);
                return UmaSoulUtils.getProperty(inputSoul)[UmaStatusUtils.StatusType.WISDOM.getId()] >= skill.getRequiredWisdom() && !result;
            }
        }
        return false;
    }

    private boolean isUmaSoul(ItemStack stack) {
        if (stack.m_41720_() instanceof UmaSoulItem) {
            return UmaSoulUtils.getGrowth(stack) != Growth.RETIRED;
        }
        return false;
    }

    private boolean isSkillBook(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SkillBookItem) {
            SkillBookItem skillbook = (SkillBookItem)item;
            return skillbook.getSkill(stack) != null;
        }
        return false;
    }

    protected void m_142365_(Player player, ItemStack resultStack) {
        resultStack.m_41678_(player.m_9236_(), player, resultStack.m_41613_());
        this.f_39768_.m_58395_(player, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.f_39770_.m_39292_((level, pos) -> player.m_5496_(SoundEvents.f_12275_, 1.0f, 1.0f));
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.f_39769_.m_8020_(0), this.f_39769_.m_8020_(1));
    }

    private void shrinkStackInSlot(int pIndex) {
        ItemStack itemstack = this.f_39769_.m_8020_(pIndex);
        itemstack.m_41774_(1);
        this.f_39769_.m_6836_(pIndex, itemstack);
    }

    protected boolean m_8039_(BlockState pState) {
        return pState.m_60713_((Block)BlockRegistry.SKILL_LEARNING_TABLE.get());
    }

    public void m_6640_() {
        if (!this.hasResult()) {
            this.f_39768_.m_6836_(0, ItemStack.f_41583_);
        } else {
            this.f_39768_.m_6836_(0, this.getResultItem());
        }
    }

    private ItemStack getResultItem() {
        ItemStack result = this.f_39769_.m_8020_(0).m_41777_();
        ItemStack supportItem = this.f_39769_.m_8020_(1).m_41777_();
        Item item = supportItem.m_41720_();
        if (item instanceof SkillBookItem) {
            SkillBookItem skillBook = (SkillBookItem)item;
            UmaSkillUtils.learnSkill(result, UmaSkillRegistry.REGISTRY.get().getKey((Object)skillBook.getSkill(supportItem)));
        }
        return result;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.f_39768_ && super.m_5882_(pStack, pSlot);
    }

    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 27, 47, this::isUmaSoul).m_266197_(1, 76, 47, this::isSkillBook).m_266198_(2, 134, 47).m_266441_();
    }
}

