/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.block.entity.ThreeGoddessBlockEntity;
import net.tracen.umapyoi.container.CommonResultSlot;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.item.ItemRegistry;

public class ThreeGoddessContainer
extends AbstractContainerMenu {
    public final ThreeGoddessBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData containerData;
    private final ContainerLevelAccess canInteractWithCallable;

    public ThreeGoddessContainer(int windowId, Inventory playerInventory, ThreeGoddessBlockEntity tileEntity, ContainerData dataIn) {
        super((MenuType)ContainerRegistry.THREE_GODDESS.get(), windowId);
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.containerData = dataIn;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        int startX = 8;
        this.m_38897_((Slot)new ThreeGoddessJewelSlot((IItemHandler)this.inventory, 0, 80, 27));
        this.m_38897_((Slot)new ThreeGoddessFactorSlot((IItemHandler)this.inventory, 1, 50, 78));
        this.m_38897_((Slot)new ThreeGoddessFactorSlot((IItemHandler)this.inventory, 2, 109, 78));
        this.m_38897_((Slot)new CommonResultSlot(playerInventory.f_35978_, (IItemHandler)this.inventory, 3, 80, 79));
        int startPlayerInvY = 137;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + row * 9 + column, startX + column * 18, startPlayerInvY + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, startX + column * 18, 195));
        }
        this.m_38884_(dataIn);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack1 = slot.m_7993_();
            itemStack = itemStack1.m_41777_();
            if (index >= 0 && index <= 3) {
                if (!this.m_38903_(itemStack1, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack1, itemStack);
            } else if (index >= 4 && index >= 4 && index < 40 && !this.m_38903_(itemStack1, 0, 3, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack1.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemStack1);
        }
        return itemStack;
    }

    private static ThreeGoddessBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof ThreeGoddessBlockEntity) {
            return (ThreeGoddessBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public ThreeGoddessContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ThreeGoddessContainer.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public boolean m_6875_(Player playerIn) {
        return ThreeGoddessContainer.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)BlockRegistry.THREE_GODDESS.get()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressionScaled() {
        int i = this.containerData.m_6413_(0);
        return i != 0 ? i * 158 / 200 : 0;
    }

    public static class ThreeGoddessJewelSlot
    extends SlotItemHandler {
        public ThreeGoddessJewelSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            if (stack.m_150930_((Item)ItemRegistry.BLANK_UMA_SOUL.get())) {
                String name = stack.m_41784_().m_128461_("name");
                return !name.equals(this.getItemHandler().getStackInSlot(1).m_41784_().m_128461_("name")) && !name.equals(this.getItemHandler().getStackInSlot(2).m_41784_().m_128461_("name"));
            }
            return false;
        }

        public int m_5866_(ItemStack stack) {
            return 1;
        }
    }

    public static class ThreeGoddessFactorSlot
    extends SlotItemHandler {
        public ThreeGoddessFactorSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(ItemStack stack) {
            boolean result = stack.m_150930_((Item)ItemRegistry.UMA_FACTOR_ITEM.get());
            if (!result) {
                return false;
            }
            boolean factorFlag = false;
            String name = stack.m_41784_().m_128461_("name");
            ItemStack soulStack = this.getItemHandler().getStackInSlot(0);
            boolean soulFlag = !soulStack.m_41619_() && stack.m_41784_().m_128461_("name").equals(soulStack.m_41784_().m_128461_("name"));
            switch (this.getSlotIndex()) {
                case 1: {
                    factorFlag = name.equals(this.getItemHandler().getStackInSlot(2).m_41784_().m_128461_("name"));
                    break;
                }
                case 2: {
                    factorFlag = name.equals(this.getItemHandler().getStackInSlot(1).m_41784_().m_128461_("name"));
                    break;
                }
            }
            return result && !soulFlag && !factorFlag;
        }
    }
}

