/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;

public abstract class SkillEvent
extends Event {
    private final ResourceLocation skill;

    public SkillEvent(ResourceLocation skill) {
        this.skill = skill;
    }

    public ResourceLocation getSkillResourceLocation() {
        return this.skill;
    }

    public UmaSkill getSkill() {
        return (UmaSkill)UmaSkillRegistry.REGISTRY.get().getValue(this.getSkillResourceLocation());
    }

    public static class ApplySkillEvent
    extends SkillEvent {
        private final Level level;
        private final Player user;

        public ApplySkillEvent(ResourceLocation skill, Level level, Player user) {
            super(skill);
            this.level = level;
            this.user = user;
        }

        public Level getLevel() {
            return this.level;
        }

        public Player getPlayer() {
            return this.user;
        }
    }

    @Cancelable
    public static class UseSkillEvent
    extends SkillEvent {
        private final Level level;
        private final Player user;

        public UseSkillEvent(ResourceLocation skill, Level level, Player user) {
            super(skill);
            this.level = level;
            this.user = user;
        }

        public Level getLevel() {
            return this.level;
        }

        public Player getPlayer() {
            return this.user;
        }
    }

    public static class LearnSkillEvent
    extends SkillEvent {
        private final ItemStack umasoul;

        public LearnSkillEvent(ResourceLocation skill, ItemStack umasoul) {
            super(skill);
            this.umasoul = umasoul;
        }

        public ItemStack getUmaSoul() {
            return this.umasoul;
        }
    }
}

