/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.events.handler;

import cn.mcmod_mmf.mmlib.client.model.BedrockModelResourceLoader;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.client.ActionBarOverlay;
import net.tracen.umapyoi.client.MotivationOverlay;
import net.tracen.umapyoi.client.SkillOverlay;
import net.tracen.umapyoi.client.key.SkillKeyMapping;
import net.tracen.umapyoi.client.model.UmaCostumeItemModel;
import net.tracen.umapyoi.client.renderer.SwimsuitRenderer;
import net.tracen.umapyoi.client.renderer.TrainningSuitRenderer;
import net.tracen.umapyoi.client.renderer.UmaCostumeRenderer;
import net.tracen.umapyoi.client.renderer.UmaSoulRenderer;
import net.tracen.umapyoi.client.renderer.UmaUniformRenderer;
import net.tracen.umapyoi.client.renderer.blockentity.SilverSupportAlbumPedestalBlockRender;
import net.tracen.umapyoi.client.renderer.blockentity.SilverUmaPedestalBlockRender;
import net.tracen.umapyoi.client.renderer.blockentity.SupportAlbumPedestalBlockRender;
import net.tracen.umapyoi.client.renderer.blockentity.ThreeGoddessBlockRender;
import net.tracen.umapyoi.client.renderer.blockentity.UmaPedestalBlockRender;
import net.tracen.umapyoi.client.renderer.blockentity.UmaStatuesBlockRender;
import net.tracen.umapyoi.item.ItemRegistry;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEvents {
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            CuriosRendererRegistry.register((Item)((Item)ItemRegistry.UMA_SOUL.get()), UmaSoulRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistry.TRAINNING_SUIT.get()), TrainningSuitRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistry.SUMMER_UNIFORM.get()), UmaUniformRenderer.SummerUniformRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistry.WINTER_UNIFORM.get()), UmaUniformRenderer.WinterUniformRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistry.SWIMSUIT.get()), SwimsuitRenderer::new);
            CuriosRendererRegistry.register((Item)((Item)ItemRegistry.UMA_COSTUME.get()), UmaCostumeRenderer::new);
        });
        event.enqueueWork(() -> {
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityRegistry.THREE_GODDESS.get()), ThreeGoddessBlockRender::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityRegistry.UMA_PEDESTAL.get()), UmaPedestalBlockRender::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityRegistry.SUPPORT_ALBUM_PEDESTAL.get()), SupportAlbumPedestalBlockRender::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityRegistry.UMA_STATUES.get()), UmaStatuesBlockRender::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityRegistry.SILVER_UMA_PEDESTAL.get()), SilverUmaPedestalBlockRender::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityRegistry.SILVER_SUPPORT_ALBUM_PEDESTAL.get()), SilverSupportAlbumPedestalBlockRender::new);
        });
    }

    @SubscribeEvent
    public static void registerModels(ModelEvent.RegisterAdditional event) {
        FileToIdConverter.m_246568_((String)"models/item/costume").m_247457_(Minecraft.m_91087_().m_91098_()).forEach((location, resource) -> {
            Umapyoi.getLogger().info("Found resource:{}", (Object)location.toString());
            event.register((ResourceLocation)ClientSetupEvents.resolveCostumeLocation(location));
        });
    }

    private static ModelResourceLocation resolveCostumeLocation(ResourceLocation location) {
        return new ModelResourceLocation(location.m_135827_(), "costume/" + location.m_135815_().substring(20, location.m_135815_().length() - 5), "inventory");
    }

    @SubscribeEvent
    public static void onBakedModel(ModelEvent.BakingCompleted event) {
        ModelResourceLocation origin = new ModelResourceLocation(ItemRegistry.UMA_COSTUME.getId(), "inventory");
        Map bakedTopLevelModels = event.getModelBakery().m_119251_();
        bakedTopLevelModels.put(origin, new UmaCostumeItemModel((BakedModel)bakedTopLevelModels.get(origin), event.getModelBakery()));
    }

    @SubscribeEvent
    public static void resourceLoadingListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new BedrockModelResourceLoader("models/umapyoi"));
    }

    @SubscribeEvent
    public static void registerKeyMapping(RegisterKeyMappingsEvent event) {
        event.register(SkillKeyMapping.KEY_USE_SKILL);
        event.register(SkillKeyMapping.KEY_FORMER_SKILL);
        event.register(SkillKeyMapping.KEY_LATTER_SKILL);
    }

    @SubscribeEvent
    public static void registerGuiOverlay(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("umapyoi.skill_overlay", (IGuiOverlay)SkillOverlay.INSTANCE);
        event.registerBelowAll("umapyoi.motivation_overlay", (IGuiOverlay)MotivationOverlay.INSTANCE);
        event.registerBelowAll("umapyoi.action_bar", (IGuiOverlay)ActionBarOverlay.INSTANCE);
    }
}

