/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.curios.UmaSuitCapProvider;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.cosmetics.CosmeticData;

public class UmaCostumeItem
extends Item {
    private static final Comparator<Holder.Reference<CosmeticData>> COMPARATOR = new DataComparator();

    public UmaCostumeItem() {
        super(Umapyoi.defaultItemProperties().m_41487_(1));
    }

    public static Stream<Holder.Reference<CosmeticData>> sortedCosmeticDataList(HolderLookup.Provider provider) {
        return UmapyoiAPI.getCosmeticDataRegistry(provider).m_214062_().sorted(COMPARATOR);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new UmaSuitCapProvider(stack, nbt);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return UmaCostumeItem.getCostumeID(itemStack).m_135827_();
    }

    public String m_5671_(ItemStack pStack) {
        return Util.m_137492_((String)"item", (ResourceLocation)UmaCostumeItem.getCostumeID(pStack)) + ".name";
    }

    public static ResourceLocation getCostumeID(ItemStack stack) {
        if (stack.m_41784_().m_128441_("cosmetic")) {
            return ResourceLocation.m_135820_((String)stack.m_41784_().m_128461_("cosmetic"));
        }
        return CosmeticData.COMMON_COSTUME;
    }

    public static ItemStack getCostume(ResourceLocation loc) {
        ItemStack defaultInstance = ((Item)ItemRegistry.UMA_COSTUME.get()).m_7968_();
        defaultInstance.m_41784_().m_128359_("cosmetic", loc.toString());
        return defaultInstance;
    }

    private static class DataComparator
    implements Comparator<Holder.Reference<CosmeticData>> {
        private DataComparator() {
        }

        @Override
        public int compare(Holder.Reference<CosmeticData> left, Holder.Reference<CosmeticData> right) {
            String leftName = left.m_205785_().m_135782_().toString();
            String rightName = right.m_205785_().m_135782_().toString();
            return leftName.compareToIgnoreCase(rightName);
        }
    }
}

