/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.recipe;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.recipe.RequestUma;

public class UmasoulIngredient
extends Ingredient {
    private final Set<Item> items;
    private final RequestUma request;

    public UmasoulIngredient(Set<Item> items, RequestUma request) {
        super(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            request.initItemStack(stack);
            return new Ingredient.ItemValue(stack);
        }));
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a UmasoulIngredient with no items");
        }
        this.items = Collections.unmodifiableSet(items);
        this.request = request;
    }

    public static UmasoulIngredient of(ItemLike item, RequestUma request) {
        return new UmasoulIngredient(Set.of(item.m_5456_()), request);
    }

    public static UmasoulIngredient of(RequestUma request) {
        return new UmasoulIngredient(Set.of((Item)ItemRegistry.BLANK_UMA_SOUL.get()), request);
    }

    public boolean test(ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.items.contains(input.m_41720_()) && this.request.test(input);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        if (this.items.size() == 1) {
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.items.iterator().next()).toString());
        } else {
            JsonArray items = new JsonArray();
            this.items.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)).sorted().forEach(name -> items.add(name.toString()));
            json.add("items", (JsonElement)items);
        }
        json.add("request", this.request.toJson());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<UmasoulIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public UmasoulIngredient parse(FriendlyByteBuf buffer) {
            Set<Item> items = Stream.generate(() -> (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS)).limit(buffer.m_130242_()).collect(Collectors.toSet());
            RequestUma request = RequestUma.fromNetwork(buffer);
            return new UmasoulIngredient(items, request);
        }

        public UmasoulIngredient parse(JsonObject json) {
            ImmutableSet items;
            if (json.has("item")) {
                items = Set.of(CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"item"), (boolean)true));
            } else if (json.has("items")) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                JsonArray itemArray = GsonHelper.m_13933_((JsonObject)json, (String)"items");
                for (int i = 0; i < itemArray.size(); ++i) {
                    builder.add((Object)CraftingHelper.getItem((String)GsonHelper.m_13805_((JsonElement)itemArray.get(i), (String)("items[" + i + "]")), (boolean)true));
                }
                items = builder.build();
            } else {
                items = Set.of((Item)ItemRegistry.BLANK_UMA_SOUL.get());
            }
            RequestUma request = RequestUma.fromJSON(json.getAsJsonObject("request"));
            return new UmasoulIngredient((Set<Item>)items, request);
        }

        public void write(FriendlyByteBuf buffer, UmasoulIngredient ingredient) {
            buffer.m_130130_(ingredient.items.size());
            for (Item item : ingredient.items) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)item);
            }
            ingredient.request.toNetwork(buffer);
        }
    }
}

