/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.factors;

import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class ExtraStatusFactor
extends UmaFactor {
    private final int statusType;

    public ExtraStatusFactor(int type) {
        super(FactorType.EXTRASTATUS);
        this.statusType = type;
    }

    @Override
    public void applyFactor(ItemStack soul, UmaFactorStack stack) {
        int level = stack.getLevel();
        double chance = (double)stack.getLevel() * 0.33;
        Random rand = new Random();
        for (int roll = 1; roll < stack.getLevel(); ++roll) {
            if (!((double)rand.nextFloat() > chance)) continue;
            --level;
        }
        if (level != 0) {
            if (this.statusType == 0) {
                UmaSoulUtils.getExtraProperty((ItemStack)soul)[this.statusType] = Math.min(5, UmaSoulUtils.getExtraProperty(soul)[this.statusType] + level);
            } else if (this.statusType == 3) {
                int[] nArray = UmaSoulUtils.getExtraProperty(soul);
                int n = this.statusType;
                nArray[n] = nArray[n] + level * 100;
            } else {
                int[] nArray = UmaSoulUtils.getExtraProperty(soul);
                int n = this.statusType;
                nArray[n] = nArray[n] + level;
            }
        }
    }

    @Override
    public Component getDescription(UmaFactorStack stack) {
        return this.getFullDescription(stack.getLevel());
    }
}

