/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.factors;

import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.registry.UmaFactorRegistry;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;

public class UmaFactor {
    private final FactorType type;
    private String descriptionId;
    private String detailId;
    public static final ResourceKey<Registry<UmaFactor>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("umapyoi", "factor"));
    public static final Codec<UmaFactor> CODEC = ResourceLocation.f_135803_.xmap(loc -> (UmaFactor)UmaFactorRegistry.REGISTRY.get().getValue(loc), instance -> UmaFactorRegistry.REGISTRY.get().getKey(instance));

    public UmaFactor(FactorType type) {
        this.type = type;
    }

    public void applyFactor(ItemStack soul, UmaFactorStack stack) {
    }

    public FactorType getFactorType() {
        return this.type;
    }

    public String toString() {
        return UmaFactorRegistry.REGISTRY.get().getKey((Object)this).toString();
    }

    public Component getDescription() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    public Component getDescription(UmaFactorStack stack) {
        return this.getDescription();
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"uma_factor", (ResourceLocation)UmaFactorRegistry.REGISTRY.get().getKey((Object)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getFullDescription(int pLevel) {
        MutableComponent mutablecomponent = this.getDescription().m_6881_();
        mutablecomponent.m_130940_(ChatFormatting.GRAY);
        mutablecomponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + pLevel)));
        return mutablecomponent;
    }

    public int getMaxLevel() {
        return this.getFactorType().getMaxLevel();
    }

    public Component getDescriptionDetail(UmaFactorStack stack) {
        return Component.m_237115_((String)this.getDetailDescriptionId());
    }

    protected String getOrCreateDescriptionDetail() {
        if (this.detailId == null) {
            this.detailId = this.getDescriptionId() + ".desc";
        }
        return this.detailId;
    }

    public String getDetailDescriptionId() {
        return this.getOrCreateDescriptionDetail();
    }
}

