/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.training.card;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.tracen.umapyoi.registry.TrainingSupportRegistry;
import net.tracen.umapyoi.registry.training.SupportStack;
import net.tracen.umapyoi.registry.training.SupportType;
import net.tracen.umapyoi.registry.training.TrainingSupport;
import net.tracen.umapyoi.registry.training.card.SupportEntry;
import net.tracen.umapyoi.utils.GachaRanking;

public class SupportCard {
    public static final Codec<SupportCard> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GachaRanking.CODEC.optionalFieldOf("ranking", (Object)GachaRanking.EASTER_EGG).forGetter(SupportCard::getGachaRanking), (App)SupportType.CODEC.fieldOf("type").forGetter(SupportCard::getSupportType), (App)SupportEntry.CODEC.listOf().fieldOf("supports").forGetter(SupportCard::getSupports), (App)ResourceLocation.f_135803_.listOf().optionalFieldOf("supporters", (Object)Lists.newArrayList()).forGetter(SupportCard::getSupporters), (App)Codec.INT.fieldOf("max_damage").forGetter(SupportCard::getMaxDamage)).apply((Applicative)instance, SupportCard::new));
    public static final ResourceKey<Registry<SupportCard>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("umapyoi", "support_card"));
    public static final ResourceLocation EMPTY_ID = new ResourceLocation("umapyoi", "blank_card");
    public static final SupportCard EMPTY = Builder.create().ranking(GachaRanking.EASTER_EGG).supportType(SupportType.GROUP).build();
    private final GachaRanking ranking;
    private final SupportType type;
    private final List<SupportEntry> supports;
    private final List<ResourceLocation> supporters;
    private final int maxDamage;

    private SupportCard(GachaRanking level, SupportType type, List<SupportEntry> supports, List<ResourceLocation> supporters, int maxDamage) {
        this.ranking = level;
        this.type = type;
        this.supports = supports;
        this.supporters = supporters;
        this.maxDamage = maxDamage;
    }

    public GachaRanking getGachaRanking() {
        return this.ranking;
    }

    public List<SupportEntry> getSupports() {
        return this.supports;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    public List<SupportStack> getSupportStacks() {
        ArrayList result = Lists.newArrayList();
        this.getSupports().forEach(sp -> result.add(new SupportStack((TrainingSupport)TrainingSupportRegistry.REGISTRY.get().getValue(sp.getFactor()), sp.getLevel(), sp.getTag())));
        return result;
    }

    public List<ResourceLocation> getSupporters() {
        return this.supporters;
    }

    public SupportType getSupportType() {
        return this.type;
    }

    public static class Builder {
        private GachaRanking level = GachaRanking.R;
        private SupportType type = SupportType.SPEED;
        private List<SupportEntry> supports = Lists.newArrayList();
        private List<ResourceLocation> supporters = Lists.newArrayList();
        private int damage = 3;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder ranking(GachaRanking level) {
            this.level = level;
            return this;
        }

        public Builder maxDamage(int damage) {
            this.damage = damage;
            return this;
        }

        public Builder supportType(SupportType type) {
            this.type = type;
            return this;
        }

        public Builder addSupport(SupportEntry support) {
            this.supports.add(support);
            return this;
        }

        public Builder addSupporter(ResourceLocation name) {
            this.supporters.add(name);
            return this;
        }

        public SupportCard build() {
            return new SupportCard(this.level, this.type, this.supports, this.supporters, this.damage);
        }
    }
}

