/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.umadata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.utils.GachaRanking;

public class UmaData {
    private static final int[] EMPTY_PROPERTY_RATE = new int[]{0, 0, 0, 0, 0};
    private static final int[] DEFAULT_MAX_PROPERTY = new int[]{18, 18, 18, 18, 18};
    private static final int[] DEFAULT_PROPERTY = new int[]{1, 1, 1, 1, 1};
    public static final ResourceLocation DEFAULT_UMA_ID = new ResourceLocation("umapyoi", "common_uma");
    public static final UmaData DEFAULT_UMA = UmaData.createNewUmamusume("common_uma", GachaRanking.R);
    public static final Codec<UmaData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("identifier").forGetter(UmaData::getIdentifier), (App)GachaRanking.CODEC.optionalFieldOf("ranking", (Object)GachaRanking.EASTER_EGG).forGetter(UmaData::getGachaRanking), (App)Codec.INT_STREAM.xmap(IntStream::toArray, Arrays::stream).optionalFieldOf("property", (Object)DEFAULT_PROPERTY).forGetter(UmaData::property), (App)Codec.INT_STREAM.xmap(IntStream::toArray, Arrays::stream).optionalFieldOf("maxProperty", (Object)DEFAULT_MAX_PROPERTY).forGetter(UmaData::maxProperty), (App)Codec.INT_STREAM.xmap(IntStream::toArray, Arrays::stream).optionalFieldOf("propertyRate", (Object)EMPTY_PROPERTY_RATE).forGetter(UmaData::propertyRate), (App)ResourceLocation.f_135803_.optionalFieldOf("uniqueSkill", (Object)UmaSkillRegistry.BASIC_PACE.getId()).forGetter(UmaData::uniqueSkill)).apply((Applicative)instance, UmaData::new));
    public static final ResourceKey<Registry<UmaData>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("umapyoi", "umadata"));
    private final ResourceLocation identifier;
    private final GachaRanking ranking;
    private final int[] property;
    private final int[] maxProperty;
    private final int[] propertyRate;
    private final ResourceLocation uniqueSkill;

    public UmaData(ResourceLocation identifier, GachaRanking ranking, int[] property, int[] maxProperty, int[] propertyRate, ResourceLocation uniqueSkill) {
        this.identifier = identifier;
        this.ranking = ranking;
        this.property = property;
        this.maxProperty = maxProperty;
        this.propertyRate = propertyRate;
        this.uniqueSkill = uniqueSkill;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public GachaRanking getGachaRanking() {
        return this.ranking;
    }

    public int[] property() {
        return this.property;
    }

    public int[] maxProperty() {
        return this.maxProperty;
    }

    public int[] propertyRate() {
        return this.propertyRate != null ? this.propertyRate : EMPTY_PROPERTY_RATE;
    }

    public ResourceLocation uniqueSkill() {
        return this.uniqueSkill;
    }

    public static UmaData createNewUmamusume(String name, GachaRanking ranking) {
        return new UmaData(new ResourceLocation("umapyoi", name), ranking, DEFAULT_PROPERTY, DEFAULT_MAX_PROPERTY, EMPTY_PROPERTY_RATE, new ResourceLocation("umapyoi", "basic_pace"));
    }

    public static UmaData createNewUmamusume(String name, GachaRanking ranking, int[] rate) {
        return new UmaData(new ResourceLocation("umapyoi", name), ranking, DEFAULT_PROPERTY, DEFAULT_MAX_PROPERTY, rate, new ResourceLocation("umapyoi", "basic_pace"));
    }
}

