/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.utils;

import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.tracen.umapyoi.events.SkillEvent;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.TrainingSupportRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.registry.training.SupportStack;
import net.tracen.umapyoi.registry.training.TrainingSupport;
import net.tracen.umapyoi.registry.training.card.SupportEntry;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UmaSkillUtils {
    public static SupportStack getSkillSupport(UmaSkill skill) {
        if (skill == null) {
            return SupportStack.EMPTY;
        }
        SupportStack result = new SupportStack((TrainingSupport)TrainingSupportRegistry.SKILL_SUPPORT.get(), 1);
        result.getOrCreateTag().m_128359_("skill", UmaSkillRegistry.REGISTRY.get().getKey((Object)skill).toString());
        return result;
    }

    public static SupportEntry getSkillSupportEnrty(ResourceLocation skill) {
        if (skill == null) {
            return null;
        }
        SupportEntry result = new SupportEntry(TrainingSupportRegistry.SKILL_SUPPORT.getId(), 1);
        result.getOrCreateTag().m_128359_("skill", skill.toString());
        return result;
    }

    public static ItemStack getSkillBook(UmaSkill skill) {
        if (skill == null) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)ItemRegistry.SKILL_BOOK.get());
        result.m_41784_().m_128359_("skill", UmaSkillRegistry.REGISTRY.get().getKey((Object)skill).toString());
        return result;
    }

    public static void syncActionPoint(ItemStack stack) {
        int max_ap = UmaSoulUtils.getProperty(stack)[4] * 200;
        UmaSoulUtils.setMaxActionPoint(stack, max_ap);
        UmaSoulUtils.setActionPoint(stack, max_ap);
    }

    public static void learnSkill(ItemStack stack, ResourceLocation skill) {
        if (!UmaSoulUtils.hasEmptySkillSlot(stack)) {
            return;
        }
        if (skill != null && UmaSkillRegistry.REGISTRY.get().containsKey(skill)) {
            ListTag skills = UmaSoulUtils.getSkills(stack);
            UmaSkill skillItem = (UmaSkill)UmaSkillRegistry.REGISTRY.get().getValue(skill);
            if (skillItem.getUpperSkill() != null && UmaSkillUtils.hasLearnedSkill(stack, skillItem.getUpperSkill())) {
                return;
            }
            StringTag tag = StringTag.m_129297_((String)skill.toString());
            int lowerSkillIndex = UmaSkillUtils.getLowerSkillIndex(stack, skill);
            if (lowerSkillIndex != -1) {
                skills.m_7615_(lowerSkillIndex, (Tag)tag);
            }
            if (!UmaSkillUtils.hasLearnedSkill(stack, skill)) {
                skills.add((Object)tag);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new SkillEvent.LearnSkillEvent(skill, stack));
    }

    public static boolean hasLearnedSkill(ItemStack stack, ResourceLocation skill) {
        ListTag skills = UmaSoulUtils.getSkills(stack);
        StringTag tag = StringTag.m_129297_((String)skill.toString());
        return skills.contains((Object)tag);
    }

    public static int getLowerSkillIndex(ItemStack stack, ResourceLocation skill) {
        ListTag skills = UmaSoulUtils.getSkills(stack);
        UmaSkill target = null;
        for (int i = 0; i < skills.size(); ++i) {
            target = (UmaSkill)UmaSkillRegistry.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)skills.get(i).m_7916_()));
            if (target.getUpperSkill() == null || target == null || !target.getUpperSkill().equals((Object)skill)) continue;
            return i;
        }
        return -1;
    }
}

