/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.utils;

import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.data.builtin.UmaDataRegistry;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.registry.umadata.Motivations;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ResultRankingUtils;

public class UmaSoulUtils {
    public static Component getTranslatedUmaName(ItemStack stack) {
        return UmaSoulUtils.getTranslatedUmaName(UmaSoulUtils.getName(stack));
    }

    public static Component getTranslatedUmaName(ResourceLocation name) {
        return Component.m_237115_((String)Util.m_137492_((String)"umadata", (ResourceLocation)name));
    }

    public static ItemStack initUmaSoul(ItemStack stack, ResourceLocation name, UmaData data) {
        ItemStack result = stack.m_41777_();
        CompoundTag tag = result.m_41784_();
        tag.m_128359_("name", name.toString());
        tag.m_128359_("ranking", data.getGachaRanking().name().toLowerCase());
        tag.m_128385_("property", data.property());
        tag.m_128385_("maxProperty", data.maxProperty());
        tag.m_128385_("propertyRate", data.propertyRate());
        UmaSoulUtils.addSkill(result, data.uniqueSkill());
        tag.m_128405_("actionPoint", data.property()[4] * 200);
        tag.m_128385_("extraProperty", new int[]{1, 6, 5, 0});
        tag.m_128405_("resultRanking", ResultRankingUtils.generateRanking(result));
        return result;
    }

    public static ResourceLocation getName(ItemStack stack) {
        return stack.m_41784_().m_128461_("name").isBlank() ? UmaDataRegistry.COMMON_UMA.m_135782_() : ResourceLocation.m_135820_((String)stack.m_41784_().m_128461_("name"));
    }

    public static int[] getProperty(ItemStack stack) {
        int[] nArray;
        if (stack.m_41784_().m_128465_("property").length > 0) {
            nArray = stack.m_41784_().m_128465_("property");
        } else {
            int[] nArray2 = new int[5];
            nArray2[0] = 1;
            nArray2[1] = 1;
            nArray2[2] = 1;
            nArray2[3] = 1;
            nArray = nArray2;
            nArray2[4] = 1;
        }
        return nArray;
    }

    public static int[] getPropertyRate(ItemStack stack) {
        int[] nArray;
        if (stack.m_41784_().m_128465_("propertyRate").length > 0) {
            nArray = stack.m_41784_().m_128465_("propertyRate");
        } else {
            int[] nArray2 = new int[5];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray = nArray2;
            nArray2[4] = 0;
        }
        return nArray;
    }

    public static int[] getExtraProperty(ItemStack stack) {
        int[] nArray;
        if (stack.m_41784_().m_128465_("extraProperty").length > 0) {
            nArray = stack.m_41784_().m_128465_("extraProperty");
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[1] = 6;
            nArray2[2] = 4;
            nArray = nArray2;
            nArray2[3] = 0;
        }
        return nArray;
    }

    public static int[] getMaxProperty(ItemStack stack) {
        int[] nArray;
        if (stack.m_41784_().m_128465_("maxProperty").length > 0) {
            nArray = stack.m_41784_().m_128465_("maxProperty");
        } else {
            int[] nArray2 = new int[5];
            nArray2[0] = 12;
            nArray2[1] = 12;
            nArray2[2] = 12;
            nArray2[3] = 12;
            nArray = nArray2;
            nArray2[4] = 12;
        }
        return nArray;
    }

    public static Motivations getMotivation(ItemStack stack) {
        return stack.m_41784_().m_128461_("motivation").isBlank() ? Motivations.NORMAL : Motivations.valueOf(stack.m_41784_().m_128461_("motivation").toUpperCase());
    }

    public static Growth getGrowth(ItemStack stack) {
        return stack.m_41784_().m_128461_("growth").isBlank() ? Growth.UNTRAINED : Growth.valueOf(stack.m_41784_().m_128461_("growth").toUpperCase());
    }

    public static void setMotivation(ItemStack stack, Motivations motivation) {
        stack.m_41784_().m_128359_("motivation", motivation.name().toLowerCase());
    }

    public static void setGrowth(ItemStack stack, Growth growth) {
        stack.m_41784_().m_128359_("growth", growth.name().toLowerCase());
    }

    public static ListTag getSkills(ItemStack stack) {
        return stack.m_41784_().m_128437_("skills", 8);
    }

    public static boolean hasSkill(ItemStack stack, ResourceLocation skill) {
        if (stack.m_41619_()) {
            return false;
        }
        for (Tag tag : stack.m_41784_().m_128437_("skills", 8)) {
            if (!tag.m_7916_().equals(skill.toString())) continue;
            return true;
        }
        return false;
    }

    public static void addSkill(ItemStack stack, ResourceLocation skill) {
        ListTag result = UmaSoulUtils.getSkills(stack);
        result.add((Object)StringTag.m_129297_((String)skill.toString()));
        stack.m_41784_().m_128365_("skills", (Tag)result);
    }

    public static int getSelectedSkillIndex(ItemStack stack) {
        return stack.m_41784_().m_128451_("selectedSkill");
    }

    public static void setSelectedSkill(ItemStack stack, int slots) {
        stack.m_41784_().m_128405_("selectedSkill", slots);
    }

    public static ResourceLocation getSelectedSkill(ItemStack stack) {
        String skill = UmaSoulUtils.getSkills(stack).m_128778_(UmaSoulUtils.getSelectedSkillIndex(stack));
        return skill.isBlank() ? UmaSkillRegistry.BASIC_PACE.getId() : ResourceLocation.m_135820_((String)skill);
    }

    public static int getSkillSlots(ItemStack stack) {
        return UmaSoulUtils.getExtraProperty(stack)[2];
    }

    public static void setSkillSlots(ItemStack stack, int slots) {
        UmaSoulUtils.getExtraProperty((ItemStack)stack)[2] = slots;
    }

    public static boolean hasEmptySkillSlot(ItemStack stack) {
        ListTag skills = UmaSoulUtils.getSkills(stack);
        return UmaSoulUtils.getSkillSlots(stack) > skills.size();
    }

    public static void selectFormerSkill(ItemStack stack) {
        if (UmaSoulUtils.getSkills(stack).size() <= 1) {
            return;
        }
        int slot = UmaSoulUtils.getSelectedSkillIndex(stack);
        UmaSoulUtils.setSelectedSkill(stack, slot == 0 ? UmaSoulUtils.getSkills(stack).size() - 1 : slot - 1);
    }

    public static void selectLatterSkill(ItemStack stack) {
        if (UmaSoulUtils.getSkills(stack).size() <= 1) {
            return;
        }
        int slot = UmaSoulUtils.getSelectedSkillIndex(stack);
        UmaSoulUtils.setSelectedSkill(stack, slot == UmaSoulUtils.getSkills(stack).size() - 1 ? 0 : slot + 1);
    }

    public static int getActionPoint(ItemStack stack) {
        return Math.max(stack.m_41784_().m_128451_("actionPoint"), 0);
    }

    public static void setActionPoint(ItemStack stack, int ap) {
        stack.m_41784_().m_128405_("actionPoint", ap);
    }

    public static void addActionPoint(ItemStack stack, int ap) {
        UmaSoulUtils.setActionPoint(stack, Math.min(UmaSoulUtils.getActionPoint(stack) + ap, UmaSoulUtils.getMaxActionPoint(stack)));
    }

    public static int getMaxActionPoint(ItemStack stack) {
        return UmaSoulUtils.getExtraProperty(stack)[3] + UmaSoulUtils.getProperty(stack)[4] * (int)(200.0 * (1.0 + (double)UmaSoulUtils.getPropertyRate(stack)[4] / 100.0));
    }

    public static void setMaxActionPoint(ItemStack stack, int ap) {
        UmaSoulUtils.getExtraProperty((ItemStack)stack)[3] = ap;
    }

    public static int getPhysique(ItemStack stack) {
        return UmaSoulUtils.getExtraProperty(stack)[0];
    }

    public static void setPhysique(ItemStack stack, int phy) {
        UmaSoulUtils.getExtraProperty((ItemStack)stack)[0] = phy;
    }

    public static void downPhysique(ItemStack stack) {
        int phy = Math.max(UmaSoulUtils.getPhysique(stack) - 1, 0);
        UmaSoulUtils.setPhysique(stack, phy);
    }

    public static int getLearningTimes(ItemStack stack) {
        return UmaSoulUtils.getExtraProperty(stack)[1];
    }

    public static void setLearningTimes(ItemStack stack, int learns) {
        UmaSoulUtils.getExtraProperty((ItemStack)stack)[1] = learns;
    }

    public static void downLearningTimes(ItemStack stack) {
        int learns = Math.max(UmaSoulUtils.getLearningTimes(stack) - 1, 0);
        UmaSoulUtils.setLearningTimes(stack, learns);
    }
}

