/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import cn.mcmod_mmf.mmlib.block.entity.SyncedBlockEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.container.ThreeGoddessContainer;
import net.tracen.umapyoi.inventory.ThreeGoddessItemHandler;
import net.tracen.umapyoi.item.FadedUmaSoulItem;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.UmaFactorUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import org.jetbrains.annotations.NotNull;

public class ThreeGoddessBlockEntity
extends SyncedBlockEntity
implements MenuProvider {
    public static final int MAX_PROCESS_TIME = 200;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new ThreeGoddessItemHandler((IItemHandler)this.inventory, Direction.UP));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new ThreeGoddessItemHandler((IItemHandler)this.inventory, Direction.DOWN));
    protected final ContainerData tileData = this.createIntArray();
    private int recipeTime;
    private int animationTime;

    public int getProcessTime() {
        return this.recipeTime;
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public ThreeGoddessBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.THREE_GODDESS.get(), pos, state);
    }

    public static void workingTick(Level level, BlockPos pos, BlockState state, ThreeGoddessBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        boolean didInventoryChange = false;
        if (blockEntity.canWork()) {
            didInventoryChange = blockEntity.processRecipe();
        } else {
            blockEntity.recipeTime = 0;
        }
        if (didInventoryChange) {
            blockEntity.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, ThreeGoddessBlockEntity blockEntity) {
        ++blockEntity.animationTime;
        if (blockEntity.canWork()) {
            ThreeGoddessBlockEntity.addWorkingParticle(level, pos);
        }
        blockEntity.animationTime %= 360;
    }

    private static void addWorkingParticle(Level pLevel, BlockPos pPos) {
        RandomSource pRand = pLevel.m_213780_();
        List<BlockPos> posOffsets = BlockPos.m_121886_((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(pos -> Math.abs(pos.m_123341_()) == 2 || Math.abs(pos.m_123343_()) == 2).map(BlockPos::m_7949_).toList();
        for (BlockPos spawnPos : posOffsets) {
            if (pRand.m_188503_(32) != 0) continue;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 2.5, (double)pPos.m_123343_() + 0.5, (double)((float)spawnPos.m_123341_() + pRand.m_188501_() * 2.0f) - 0.5, (double)spawnPos.m_123342_() + 2.0 - (double)pRand.m_188501_(), (double)((float)spawnPos.m_123343_() + pRand.m_188501_() * 2.0f) - 0.5);
        }
    }

    private boolean processRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.recipeTime;
        if (this.recipeTime < 200) {
            return false;
        }
        this.recipeTime = 0;
        ItemStack resultStack = this.getResultItem();
        this.inventory.setStackInSlot(3, resultStack.m_41777_());
        this.inventory.getStackInSlot(0).m_41774_(1);
        this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    private ItemStack getResultItem() {
        ResourceLocation name;
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        ItemStack left = this.inventory.getStackInSlot(1);
        ItemStack right = this.inventory.getStackInSlot(2);
        Registry<UmaData> registry = UmapyoiAPI.getUmaDataRegistry(this.m_58904_());
        name = registry.m_7804_(name = ResourceLocation.m_135820_((String)this.inventory.getStackInSlot(0).m_41784_().m_128461_("name"))) ? name : UmaData.DEFAULT_UMA_ID;
        UmaData data = registry.m_6612_(name).orElse(UmaData.DEFAULT_UMA);
        ItemStack result = UmaSoulUtils.initUmaSoul(((Item)ItemRegistry.UMA_SOUL.get()).m_7968_(), name, data).m_41777_();
        if (!left.m_41619_() && !right.m_41619_()) {
            UmaFactorUtils.deserializeNBT(left.m_41784_()).forEach(fac -> fac.applyFactor(result));
            UmaFactorUtils.deserializeNBT(right.m_41784_()).forEach(fac -> fac.applyFactor(result));
        }
        return result;
    }

    private boolean canWork() {
        if (!this.hasInput()) {
            return false;
        }
        ItemStack outputStack = this.inventory.getStackInSlot(3);
        return outputStack.m_41619_();
    }

    private boolean hasInput() {
        return this.inventory.getStackInSlot(0).m_41720_() instanceof FadedUmaSoulItem && this.inventory.getStackInSlot(1).m_41619_() == this.inventory.getStackInSlot(2).m_41619_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || !side.equals((Object)Direction.DOWN)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 4; ++i) {
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeTime = compound.m_128451_("RecipeTime");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("RecipeTime", this.recipeTime);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                ThreeGoddessBlockEntity.this.inventoryChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    if (stack.m_150930_((Item)ItemRegistry.BLANK_UMA_SOUL.get())) {
                        String name = stack.m_41784_().m_128461_("name");
                        return !name.equals(this.getStackInSlot(1).m_41784_().m_128461_("name")) && !name.equals(this.getStackInSlot(2).m_41784_().m_128461_("name"));
                    }
                    return false;
                }
                if (slot == 1) {
                    boolean result = stack.m_150930_((Item)ItemRegistry.UMA_FACTOR_ITEM.get());
                    boolean factorFlag = false;
                    String name = stack.m_41784_().m_128461_("name");
                    ItemStack soulStack = this.getStackInSlot(0);
                    boolean soulFlag = !soulStack.m_41619_() && stack.m_41784_().m_128461_("name").equals(soulStack.m_41784_().m_128461_("name"));
                    factorFlag = name.equals(this.getStackInSlot(2).m_41784_().m_128461_("name"));
                    return result && !soulFlag && !factorFlag;
                }
                if (slot == 2) {
                    boolean result = stack.m_150930_((Item)ItemRegistry.UMA_FACTOR_ITEM.get());
                    boolean factorFlag = false;
                    String name = stack.m_41784_().m_128461_("name");
                    ItemStack soulStack = this.getStackInSlot(0);
                    boolean soulFlag = !soulStack.m_41619_() && stack.m_41784_().m_128461_("name").equals(soulStack.m_41784_().m_128461_("name"));
                    factorFlag = name.equals(this.getStackInSlot(1).m_41784_().m_128461_("name"));
                    return result && !soulFlag && !factorFlag;
                }
                return super.isItemValid(slot, stack);
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                switch (index) {
                    case 0: {
                        return ThreeGoddessBlockEntity.this.recipeTime;
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        ThreeGoddessBlockEntity.this.recipeTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new ThreeGoddessContainer(id, player, this, this.tileData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.umapyoi.three_goddess");
    }
}

