/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.compat.jei.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.tracen.umapyoi.compat.jei.recipes.JEISimpleRecipe;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public final class UmapyoiJEIRecipes {
    public static JEISimpleRecipe gachaUmasoul(Ingredient ingredient, GachaRanking ... list) {
        Registry<UmaData> registry = ClientUtils.getClientUmaDataRegistry();
        Set keys = registry.m_6566_();
        ArrayList input = Lists.newArrayList();
        Collections.addAll(input, ingredient.m_43908_());
        ArrayList output = Lists.newArrayList();
        keys.stream().filter(UmapyoiJEIRecipes.umaSoulRanking(list)).forEach(key -> {
            ItemStack result = ((Item)ItemRegistry.BLANK_UMA_SOUL.get()).m_7968_();
            result.m_41784_().m_128359_("name", key.toString());
            output.add(result);
        });
        return new JEISimpleRecipe(input, output);
    }

    public static JEISimpleRecipe gachaSupportCard(Ingredient ingredient, GachaRanking ... list) {
        Registry<SupportCard> registry = ClientUtils.getClientSupportCardRegistry();
        Set keys = registry.m_6566_();
        ArrayList input = Lists.newArrayList();
        Collections.addAll(input, ingredient.m_43908_());
        ArrayList output = Lists.newArrayList();
        keys.stream().filter(UmapyoiJEIRecipes.supportCardRanking(list)).forEach(key -> {
            ItemStack result = ((Item)ItemRegistry.SUPPORT_CARD.get()).m_7968_();
            result.m_41784_().m_128359_("support_card", key.toString());
            result.m_41784_().m_128359_("ranking", ((SupportCard)registry.m_7745_(key)).getGachaRanking().name().toLowerCase());
            result.m_41784_().m_128405_("maxDamage", ((SupportCard)registry.m_7745_(key)).getMaxDamage());
            output.add(result);
        });
        return new JEISimpleRecipe(input, output);
    }

    public static JEISimpleRecipe disassembleUmasoul(ItemStack result, GachaRanking ranking) {
        Registry<UmaData> registry = ClientUtils.getClientUmaDataRegistry();
        Set keys = registry.m_6566_();
        ArrayList input = Lists.newArrayList();
        ArrayList output = Lists.newArrayList((Object[])new ItemStack[]{result});
        keys.stream().filter(key -> ((UmaData)registry.m_7745_(key)).getGachaRanking() == ranking).forEach(key -> {
            ItemStack initUmaSoul = UmaSoulUtils.initUmaSoul(((Item)ItemRegistry.UMA_SOUL.get()).m_7968_(), key, (UmaData)registry.m_7745_(key));
            UmaSoulUtils.setPhysique(initUmaSoul, 5);
            input.add(initUmaSoul);
        });
        return new JEISimpleRecipe(input, output);
    }

    public static JEISimpleRecipe disassembleSupportCard(ItemStack result, GachaRanking ranking) {
        Registry<SupportCard> registry = ClientUtils.getClientSupportCardRegistry();
        Set keys = registry.m_6566_();
        ArrayList input = Lists.newArrayList();
        ArrayList output = Lists.newArrayList((Object[])new ItemStack[]{result});
        keys.stream().filter(key -> ((SupportCard)registry.m_7745_(key)).getGachaRanking() == ranking).forEach(key -> {
            ItemStack card = ((Item)ItemRegistry.SUPPORT_CARD.get()).m_7968_();
            card.m_41784_().m_128359_("support_card", key.toString());
            card.m_41784_().m_128359_("ranking", ((SupportCard)registry.m_7745_(key)).getGachaRanking().name().toLowerCase());
            card.m_41784_().m_128405_("maxDamage", ((SupportCard)registry.m_7745_(key)).getMaxDamage());
            input.add(card);
        });
        return new JEISimpleRecipe(input, output);
    }

    private static Predicate<? super ResourceLocation> umaSoulRanking(GachaRanking ... list) {
        return key -> {
            Registry<UmaData> registry = ClientUtils.getClientUmaDataRegistry();
            for (GachaRanking gachaRanking : list) {
                if (((UmaData)registry.m_7745_(key)).getGachaRanking() != gachaRanking) continue;
                return true;
            }
            return false;
        };
    }

    private static Predicate<? super ResourceLocation> supportCardRanking(GachaRanking ... list) {
        return key -> {
            Registry<SupportCard> registry = ClientUtils.getClientSupportCardRegistry();
            for (GachaRanking gachaRanking : list) {
                if (((SupportCard)registry.m_7745_(key)).getGachaRanking() != gachaRanking) continue;
                return true;
            }
            return false;
        };
    }
}

