/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.container;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.block.BlockRegistry;
import net.tracen.umapyoi.container.ContainerRegistry;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;

public class UmaSelectMenu
extends AbstractContainerMenu {
    private final ContainerLevelAccess access;
    private final Level level;
    private ResourceLocation itemName;
    private List<ResourceLocation> recipes = Lists.newArrayList();
    private ItemStack inputTicket = ItemStack.f_41583_;
    private ItemStack inputLapis = ItemStack.f_41583_;
    final Slot inputTicketSlot;
    final Slot inputLapisSlot;
    final Slot resultSlot;
    Runnable slotUpdateListener = () -> {};
    public final Container container = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            UmaSelectMenu.this.m_6199_((Container)this);
            UmaSelectMenu.this.slotUpdateListener.run();
        }
    };
    final ResultContainer resultContainer = new ResultContainer();

    public UmaSelectMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public UmaSelectMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        this((MenuType)ContainerRegistry.UMA_SELECT_MENU.get(), pContainerId, pPlayerInventory, pAccess);
    }

    public UmaSelectMenu(@Nullable MenuType<?> pType, int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super(pType, pContainerId);
        this.access = pAccess;
        this.level = pPlayerInventory.f_35978_.m_9236_();
        this.itemName = null;
        this.inputTicketSlot = this.m_38897_(new Slot(this.container, 0, 19, 35){

            public boolean m_5857_(ItemStack pStack) {
                return (pStack.m_204117_(UmapyoiItemTags.UMA_TICKET) || pStack.m_204117_(UmapyoiItemTags.CARD_TICKET)) && !pStack.m_204117_(UmapyoiItemTags.COMMON_GACHA_ITEM);
            }
        });
        this.inputLapisSlot = this.m_38897_(new Slot(this.container, 1, 19, 65){

            public boolean m_5857_(ItemStack pStack) {
                return pStack.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 2, 142, 51){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                ItemStack ticket = UmaSelectMenu.this.inputTicketSlot.m_6201_(1);
                ItemStack lapis = UmaSelectMenu.this.inputLapisSlot.m_6201_(1);
                if (!ticket.m_41619_() && !lapis.m_41619_()) {
                    UmaSelectMenu.this.setupResultSlot();
                }
                super.m_142406_(player, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)pPlayerInventory, j + i * 9 + 9, 8 + j * 18, 104 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)pPlayerInventory, k, 8 + k * 18, 162));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return UmaSelectMenu.m_38889_((ContainerLevelAccess)this.access, (Player)playerIn, (Block)((Block)BlockRegistry.UMA_SELECT_BLOCK.get()));
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 2) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex != 0 && pIndex != 1) {
                if (pIndex >= 3 && pIndex < 39) {
                    int i;
                    int n = i = this.shouldQuickMoveToAdditionalSlot(itemstack) ? 1 : 0;
                    if (!this.m_38903_(itemstack1, i, 2, false)) {
                        return ItemStack.f_41583_;
                    }
                }
            } else if (!this.m_38903_(itemstack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
        }
        return itemstack;
    }

    protected boolean shouldQuickMoveToAdditionalSlot(ItemStack pStack) {
        return pStack.m_204117_(Tags.Items.ENCHANTING_FUELS);
    }

    public List<ResourceLocation> getRecipes() {
        return this.recipes;
    }

    public boolean hasInputItem() {
        return this.inputTicketSlot.m_6657_() && this.inputLapisSlot.m_6657_() && !this.recipes.isEmpty();
    }

    public void registerUpdateListener(Runnable pListener) {
        this.slotUpdateListener = pListener;
    }

    public void m_6199_(Container pInventory) {
        ItemStack ticket = this.inputTicketSlot.m_7993_();
        ItemStack lapis = this.inputLapisSlot.m_7993_();
        boolean setupFlag = false;
        if (!ticket.m_150930_(this.inputTicket.m_41720_())) {
            this.inputTicket = ticket.m_41777_();
            setupFlag = true;
        }
        if (!lapis.m_150930_(this.inputLapis.m_41720_())) {
            this.inputLapis = lapis.m_41777_();
            setupFlag = true;
        }
        if (setupFlag) {
            this.setupRecipeList(pInventory, this.inputTicket, this.inputLapis);
        }
    }

    public ResourceLocation getItemName() {
        return this.itemName;
    }

    public void setItemName(ResourceLocation itemName) {
        if (this.itemName == null || !this.itemName.equals((Object)itemName)) {
            this.itemName = itemName;
            this.setupResultSlot();
        }
    }

    private void setupRecipeList(Container pContainer, ItemStack ticket, ItemStack lapis) {
        this.recipes.clear();
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!ticket.m_41619_() && !lapis.m_41619_()) {
            this.recipes = ticket.m_204117_(UmapyoiItemTags.CARD_TICKET) ? (List)UmapyoiAPI.getSupportCardRegistry(this.level).m_6566_().stream().sorted(SelectComparator.INSTANCE).collect(Collectors.toCollection(Lists::newArrayList)) : (List)UmapyoiAPI.getUmaDataRegistry(this.level).m_6566_().stream().sorted(SelectComparator.INSTANCE).collect(Collectors.toCollection(Lists::newArrayList));
        }
        this.m_38946_();
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.getItemName() != null) {
            ItemStack result = this.inputTicket.m_41777_();
            result.m_41764_(1);
            result.m_41784_().m_128359_("name", this.getItemName().toString());
            this.resultSlot.m_5852_(result);
        } else {
            this.itemName = null;
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public ContainerLevelAccess getAccess() {
        return this.access;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, this.container));
    }

    public static class SelectComparator
    implements Comparator<ResourceLocation> {
        public static final SelectComparator INSTANCE = new SelectComparator();

        private SelectComparator() {
        }

        @Override
        public int compare(ResourceLocation left, ResourceLocation right) {
            String leftName = left.toString();
            String rightName = right.toString();
            return leftName.compareToIgnoreCase(rightName);
        }
    }
}

