/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.registry.training.SupportStack;
import net.tracen.umapyoi.registry.training.SupportType;
import net.tracen.umapyoi.registry.training.TrainingSupport;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class TrainingItem
extends Item
implements SupportContainer {
    private final SupportType type;
    private final Supplier<TrainingSupport> support;
    private final int level;

    public TrainingItem(SupportType type, Supplier<TrainingSupport> support, int level) {
        super(Umapyoi.defaultItemProperties());
        this.type = type;
        this.support = support;
        this.level = level;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.m_5776_()) {
            return super.m_7203_(pLevel, pPlayer, pUsedHand);
        }
        ItemStack soul = UmapyoiAPI.getUmaSoul((LivingEntity)pPlayer);
        ItemStack itemInHand = pPlayer.m_21120_(pUsedHand);
        return this.learning(pLevel, pPlayer, soul, itemInHand);
    }

    private InteractionResultHolder<ItemStack> learning(Level pLevel, Player pPlayer, ItemStack soul, ItemStack training) {
        if (soul.m_41619_()) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"umapyoi.no_umasoul_equiped"), true);
            return InteractionResultHolder.m_19100_((Object)training);
        }
        if (UmaSoulUtils.getLearningTimes(soul) <= 0) {
            pPlayer.m_5661_((Component)Component.m_237115_((String)"umapyoi.learning.no_learning_time"), true);
            return InteractionResultHolder.m_19100_((Object)training);
        }
        if (this.getSupport().applySupport(soul, pLevel.m_213780_())) {
            UmaSoulUtils.downLearningTimes(soul);
            pPlayer.m_5496_(SoundEvents.f_11871_, 0.8f, 0.8f + pLevel.m_213780_().m_188501_() * 0.4f);
            pPlayer.m_36335_().m_41524_(training.m_41720_(), 30);
            training.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)training);
        }
        pPlayer.m_5661_((Component)Component.m_237115_((String)"umapyoi.learning.can_not_learn"), true);
        return InteractionResultHolder.m_19100_((Object)training);
    }

    public boolean m_142207_(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pPlayer.m_9236_().m_5776_()) {
            return super.m_142207_(pStack, pSlot, pAction, pPlayer);
        }
        if (pAction != ClickAction.SECONDARY || pPlayer.m_36335_().m_41519_(pStack.m_41720_())) {
            return false;
        }
        ItemStack soul = pSlot.m_7993_();
        return this.learning(pPlayer.m_9236_(), pPlayer, soul, pStack).m_19089_() == InteractionResult.SUCCESS;
    }

    protected SupportStack getSupport() {
        return (SupportStack)Suppliers.memoize(() -> new SupportStack(this.support.get(), this.level)).get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add(this.getSupport().getDescription());
    }

    @Override
    public boolean isConsumable(Level level, ItemStack stack) {
        return true;
    }

    @Override
    public GachaRanking getSupportLevel(Level level, ItemStack stack) {
        return GachaRanking.values()[this.level - 1];
    }

    @Override
    public SupportType getSupportType(Level level, ItemStack stack) {
        return this.type;
    }

    @Override
    public List<SupportStack> getSupports(Level level, ItemStack stack) {
        return ImmutableList.of((Object)this.getSupport());
    }

    @Override
    public Predicate<ItemStack> canSupport(Level level, ItemStack stack) {
        return soul -> true;
    }
}

