/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.network;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.events.SkillEvent;
import net.tracen.umapyoi.registry.UmaSkillRegistry;
import net.tracen.umapyoi.registry.skills.UmaSkill;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class UseSkillPacket {
    private final String message;

    public UseSkillPacket(FriendlyByteBuf buffer) {
        this.message = buffer.m_130136_(Short.MAX_VALUE);
    }

    public UseSkillPacket(String message) {
        this.message = message;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.message);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player.m_5833_()) {
                return;
            }
            ItemStack umaSoul = UmapyoiAPI.getUmaSoul((LivingEntity)player);
            if (!umaSoul.m_41619_()) {
                ResourceLocation selectedSkillName = UmaSoulUtils.getSelectedSkill(umaSoul);
                UmaSkill selectedSkill = (UmaSkill)UmaSkillRegistry.REGISTRY.get().getValue(selectedSkillName);
                if (selectedSkill == null) {
                    player.m_5661_((Component)Component.m_237115_((String)"umapyoi.unknown_skill"), true);
                    return;
                }
                if (MinecraftForge.EVENT_BUS.post((Event)new SkillEvent.UseSkillEvent(selectedSkillName, player.m_9236_(), (Player)player))) {
                    return;
                }
                int ap = UmaSoulUtils.getActionPoint(umaSoul);
                if (ap >= selectedSkill.getActionPoint()) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((Holder)ForgeRegistries.SOUND_EVENTS.getHolder((Object)selectedSkill.getSound()).get(), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_217043_().m_188505_()));
                    selectedSkill.applySkill(player.m_9236_(), (LivingEntity)player);
                    UmaSoulUtils.setActionPoint(umaSoul, ap - selectedSkill.getActionPoint());
                    MinecraftForge.EVENT_BUS.post((Event)new SkillEvent.ApplySkillEvent(UmaSkillRegistry.REGISTRY.get().getKey((Object)selectedSkill), player.m_9236_(), (Player)player));
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"umapyoi.not_enough_ap"), true);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

