/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.factors;

import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.registry.factors.FactorType;
import net.tracen.umapyoi.registry.factors.UmaFactor;
import net.tracen.umapyoi.registry.factors.UmaFactorStack;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class WhiteExtraStatusFactor
extends UmaFactor {
    private final int statusType;

    public WhiteExtraStatusFactor(int type) {
        super(FactorType.OTHER);
        this.statusType = type;
    }

    @Override
    public void applyFactor(ItemStack soul, UmaFactorStack stack) {
        int level = stack.getLevel();
        boolean isAP = this.statusType == 3;
        double chance = (double)stack.getLevel() * 0.2;
        Random rand = new Random();
        for (int roll = 0; roll < stack.getLevel(); ++roll) {
            if (!((double)rand.nextFloat() > chance)) continue;
            --level;
        }
        if (level != 0) {
            if (this.statusType == 0) {
                UmaSoulUtils.getExtraProperty((ItemStack)soul)[this.statusType] = Math.min(5, UmaSoulUtils.getExtraProperty(soul)[this.statusType] + level);
            } else if (isAP) {
                int[] nArray = UmaSoulUtils.getExtraProperty(soul);
                int n = this.statusType;
                nArray[n] = nArray[n] + level * 100;
            } else {
                int[] nArray = UmaSoulUtils.getExtraProperty(soul);
                int n = this.statusType;
                nArray[n] = nArray[n] + level;
            }
        }
    }

    @Override
    public Component getDescription(UmaFactorStack stack) {
        return this.getFullDescription(stack.getLevel());
    }
}

