/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.villager;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.tracen.umapyoi.block.BlockRegistry;

public class VillageRegistry {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"umapyoi");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"umapyoi");
    public static final RegistryObject<PoiType> TRAINER_POI = POI_TYPES.register("trainer_poi", () -> VillageRegistry.createPOI(VillageRegistry.assembleStates((Block)BlockRegistry.TRAINING_FACILITY.get())));
    public static final RegistryObject<VillagerProfession> TRAINER = PROFESSIONS.register("trainer", () -> VillageRegistry.createProf("trainer", TRAINER_POI, SoundEvents.f_12571_));

    private static PoiType createPOI(Collection<BlockState> block) {
        return new PoiType((Set)ImmutableSet.copyOf(block), 1, 1);
    }

    private static VillagerProfession createProf(String name, RegistryObject<PoiType> poi, SoundEvent sound) {
        ResourceKey poiName = Objects.requireNonNull(poi.getKey());
        return new VillagerProfession(name, holder -> holder.m_203565_(poiName), holder -> holder.m_203565_(poiName), ImmutableSet.of(), ImmutableSet.of(), sound);
    }

    private static Collection<BlockState> assembleStates(Block block) {
        return block.m_49965_().m_61056_().stream().collect(Collectors.toList());
    }
}

