/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import cn.mcmod_mmf.mmlib.block.entity.SyncedBlockEntity;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.block.entity.Gachable;
import net.tracen.umapyoi.data.tag.UmapyoiItemTags;
import net.tracen.umapyoi.inventory.CommonItemHandler;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.training.card.SupportCard;
import net.tracen.umapyoi.utils.ClientUtils;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.GachaUtils;
import org.jetbrains.annotations.NotNull;

public class SupportAlbumPedestalBlockEntity
extends SyncedBlockEntity
implements Gachable {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final Random RANDOM = new Random();
    public static final int MAX_PROCESS_TIME = 200;
    private final ItemStackHandler inventory = this.createHandler();
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new CommonItemHandler((IItemHandler)this.inventory, Direction.UP, 1, 0));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new CommonItemHandler((IItemHandler)this.inventory, Direction.DOWN, 1, 0));
    protected final ContainerData tileData = this.createIntArray();
    private int recipeTime;
    private int animationTime;

    public int getProcessTime() {
        return this.recipeTime;
    }

    public int getAnimationTime() {
        return this.animationTime;
    }

    public SupportAlbumPedestalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.SUPPORT_ALBUM_PEDESTAL.get(), pos, state);
    }

    public static void workingTick(Level level, BlockPos pos, BlockState state, SupportAlbumPedestalBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        boolean didInventoryChange = false;
        if (blockEntity.canWork()) {
            didInventoryChange = blockEntity.processRecipe();
        } else {
            blockEntity.recipeTime = 0;
        }
        if (didInventoryChange) {
            blockEntity.inventoryChanged();
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, SupportAlbumPedestalBlockEntity blockEntity) {
        ++blockEntity.animationTime;
        if (blockEntity.canWork()) {
            ClientUtils.addSummonParticle(level, pos);
        }
        SupportAlbumPedestalBlockEntity.bookAnimationTick(level, pos, state, blockEntity);
        blockEntity.animationTime %= 360;
    }

    private static void bookAnimationTick(Level pLevel, BlockPos pPos, BlockState pState, SupportAlbumPedestalBlockEntity pBlockEntity) {
        float f2;
        pBlockEntity.oOpen = pBlockEntity.open;
        pBlockEntity.oRot = pBlockEntity.rot;
        Player player = pLevel.m_45924_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)pPos.m_123341_() + 0.5);
            double d1 = player.m_20189_() - ((double)pPos.m_123343_() + 0.5);
            pBlockEntity.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
        } else {
            pBlockEntity.tRot += 0.02f;
        }
        if (!pBlockEntity.isEmpty()) {
            pBlockEntity.open += 0.1f;
            if (pBlockEntity.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float f1 = pBlockEntity.flipT;
                do {
                    pBlockEntity.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (f1 == pBlockEntity.flipT);
            }
        } else {
            pBlockEntity.open -= 0.1f;
        }
        while (pBlockEntity.rot >= (float)Math.PI) {
            pBlockEntity.rot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.rot < (float)(-Math.PI)) {
            pBlockEntity.rot += (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot >= (float)Math.PI) {
            pBlockEntity.tRot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot < (float)(-Math.PI)) {
            pBlockEntity.tRot += (float)Math.PI * 2;
        }
        for (f2 = pBlockEntity.tRot - pBlockEntity.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        pBlockEntity.rot += f2 * 0.4f;
        pBlockEntity.open = Mth.m_14036_((float)pBlockEntity.open, (float)0.0f, (float)1.0f);
        ++pBlockEntity.time;
        pBlockEntity.oFlip = pBlockEntity.flip;
        float f = (pBlockEntity.flipT - pBlockEntity.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)f3);
        pBlockEntity.flipA += (f - pBlockEntity.flipA) * 0.9f;
        pBlockEntity.flip += pBlockEntity.flipA;
    }

    private boolean processRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.recipeTime;
        if (this.recipeTime < 200) {
            return false;
        }
        this.recipeTime = 0;
        ItemStack resultStack = this.getResultItem();
        this.inventory.setStackInSlot(0, resultStack.m_41777_());
        this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    private ItemStack getResultItem() {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        RandomSource rand = this.m_58904_().m_213780_();
        Registry<SupportCard> registry = UmapyoiAPI.getSupportCardRegistry(this.m_58904_());
        @NotNull Collection keys = registry.m_6566_().stream().filter(this.getFilter(this.m_58904_(), this.getStoredItem())).collect(Collectors.toCollection(Lists::newArrayList));
        ResourceLocation key = keys.stream().skip(keys.isEmpty() ? 0L : (long)rand.m_188503_(keys.size())).findFirst().orElse(new ResourceLocation("umapyoi", "blank_card"));
        ItemStack result = ((Item)ItemRegistry.SUPPORT_CARD.get()).m_7968_();
        result.m_41784_().m_128359_("support_card", key.toString());
        result.m_41784_().m_128359_("ranking", ((SupportCard)registry.m_7745_(key)).getGachaRanking().name().toLowerCase());
        result.m_41784_().m_128405_("maxDamage", ((SupportCard)registry.m_7745_(key)).getMaxDamage());
        return result;
    }

    private boolean canWork() {
        return !this.getStoredItem().m_41619_() && this.getStoredItem().m_204117_(UmapyoiItemTags.CARD_TICKET);
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41620_(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            ItemStack item = this.getStoredItem().m_41620_(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        drops.add((Object)this.inventory.getStackInSlot(0));
        return drops;
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputHandler.invalidate();
        this.outputHandler.invalidate();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeTime = compound.m_128451_("RecipeTime");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("RecipeTime", this.recipeTime);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                SupportAlbumPedestalBlockEntity.this.inventoryChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                switch (index) {
                    case 0: {
                        return SupportAlbumPedestalBlockEntity.this.recipeTime;
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        SupportAlbumPedestalBlockEntity.this.recipeTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    @Override
    public Predicate<? super ResourceLocation> getFilter(Level level, ItemStack input) {
        return resloc -> {
            int ssrHit;
            if (!input.m_41784_().m_128461_("name").isBlank()) {
                return resloc.equals((Object)ResourceLocation.m_135820_((String)input.m_41784_().m_128461_("name")));
            }
            if (input.m_204117_(UmapyoiItemTags.SSR_CARD_TICKET)) {
                return ((SupportCard)UmapyoiAPI.getSupportCardRegistry(level).m_7745_(resloc)).getGachaRanking() == GachaRanking.SSR;
            }
            if (input.m_150930_((Item)ItemRegistry.BLANK_TICKET.get())) {
                return ((SupportCard)UmapyoiAPI.getSupportCardRegistry(level).m_7745_(resloc)).getGachaRanking() == GachaRanking.R;
            }
            boolean cfgFlag = GachaUtils.checkGachaConfig();
            int n = ssrHit = cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SSR.get() : 10;
            if (input.m_204117_(UmapyoiItemTags.SR_CARD_TICKET)) {
                int gacha_roll = level.m_213780_().m_188503_(cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SUM.get() - (Integer)UmapyoiConfig.GACHA_PROBABILITY_R.get() : 30);
                return ((SupportCard)UmapyoiAPI.getSupportCardRegistry(level).m_7745_(resloc)).getGachaRanking() == (gacha_roll < ssrHit ? GachaRanking.SSR : GachaRanking.SR);
            }
            int gacha_roll = level.m_213780_().m_188503_(cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SUM.get() : 100);
            int srHit = ssrHit + (cfgFlag ? (Integer)UmapyoiConfig.GACHA_PROBABILITY_SR.get() : 20);
            return ((SupportCard)UmapyoiAPI.getSupportCardRegistry(level).m_7745_(resloc)).getGachaRanking() == (gacha_roll < ssrHit ? GachaRanking.SSR : (gacha_roll < srHit ? GachaRanking.SR : GachaRanking.R));
        };
    }
}

