/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.block.entity;

import cn.mcmod_mmf.mmlib.block.entity.SyncedBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.tracen.umapyoi.block.entity.BlockEntityRegistry;
import net.tracen.umapyoi.container.TrainingFacilityContainer;
import net.tracen.umapyoi.inventory.CommonItemHandler;
import net.tracen.umapyoi.inventory.TerminalResultHandler;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.item.UmaSoulItem;
import net.tracen.umapyoi.registry.training.SupportContainer;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import org.jetbrains.annotations.NotNull;

public class TrainingFacilityBlockEntity
extends SyncedBlockEntity
implements MenuProvider {
    public static final int MAX_PROCESS_TIME = 260;
    private final ItemStackHandler inventory = this.createHandler();
    protected final ContainerData tileData;
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new CommonItemHandler((IItemHandler)this.inventory, Direction.UP, 7, 0));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new TerminalResultHandler((IItemHandler)this.inventory, 0));
    private int recipeTime;

    public TrainingFacilityBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.TRAINING_FACILITY.get(), pos, state);
        this.tileData = this.createIntArray();
    }

    public static void workingTick(Level level, BlockPos pos, BlockState state, TrainingFacilityBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        boolean didInventoryChange = false;
        if (blockEntity.canWork()) {
            didInventoryChange = blockEntity.processRecipe();
        } else {
            blockEntity.recipeTime = 0;
        }
        if (didInventoryChange) {
            blockEntity.inventoryChanged();
        }
    }

    private boolean processRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.recipeTime;
        if (this.recipeTime < 260) {
            return false;
        }
        this.recipeTime = 0;
        ItemStack resultStack = this.getResultItem();
        this.inventory.setStackInSlot(0, resultStack);
        this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_11871_, SoundSource.BLOCKS, 1.0f, 1.0f);
        for (int i = 1; i < 7; ++i) {
            ItemStack supportItem = this.inventory.getStackInSlot(i);
            Item item = supportItem.m_41720_();
            if (!(item instanceof SupportContainer)) continue;
            SupportContainer supports = (SupportContainer)item;
            if (supports.isConsumable(this.m_58904_(), supportItem)) {
                supportItem.m_41774_(1);
                continue;
            }
            if (!supportItem.m_220157_(1, this.m_58904_().m_213780_(), null)) continue;
            this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_144050_, SoundSource.BLOCKS, 1.0f, 1.0f);
            supportItem.m_41774_(1);
            supportItem.m_41721_(0);
        }
        return true;
    }

    private ItemStack getResultItem() {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        ItemStack result = this.inventory.getStackInSlot(0).m_41777_();
        UmaSoulUtils.setGrowth(result, Growth.TRAINED);
        UmaSoulUtils.downPhysique(result);
        for (int i = 1; i < 7; ++i) {
            ItemStack supportItem = this.inventory.getStackInSlot(i);
            Item item = supportItem.m_41720_();
            if (!(item instanceof SupportContainer)) continue;
            SupportContainer supports = (SupportContainer)item;
            supports.getSupports(this.m_58904_(), supportItem).forEach(support -> support.applySupport(result, this.f_58857_.m_213780_()));
        }
        return result;
    }

    private boolean canWork() {
        return this.hasInput();
    }

    private boolean hasInput() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (input.m_41720_() instanceof UmaSoulItem && UmaSoulUtils.getGrowth(input) != Growth.RETIRED && UmaSoulUtils.getPhysique(input) > 0) {
            for (int i = 1; i < 7; ++i) {
                SupportContainer supports;
                ItemStack supportItem = this.inventory.getStackInSlot(i);
                Item item = supportItem.m_41720_();
                if (!(item instanceof SupportContainer) || (supports = (SupportContainer)item).canSupport(this.f_58857_, supportItem).test(input)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.m_122779_();
        for (int i = 0; i < 7; ++i) {
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    public void m_7651_() {
        super.m_7651_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.recipeTime = compound.m_128451_("RecipeTime");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("RecipeTime", this.recipeTime);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
                TrainingFacilityBlockEntity.this.inventoryChanged();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    if (!stack.m_150930_((Item)ItemRegistry.UMA_SOUL.get()) || UmaSoulUtils.getGrowth(stack) == Growth.RETIRED) {
                        return false;
                    }
                    for (int i = 1; i < 7; ++i) {
                        ItemStack other = this.getStackInSlot(i);
                        if (other.m_41619_()) continue;
                        Item item = other.m_41720_();
                        if (item instanceof SupportContainer) {
                            SupportContainer support = (SupportContainer)item;
                            if (support.canSupport(TrainingFacilityBlockEntity.this.m_58904_(), other).test(stack)) continue;
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
                Item other = stack.m_41720_();
                if (other instanceof SupportContainer) {
                    SupportContainer support = (SupportContainer)other;
                    ItemStack soul = this.getStackInSlot(0);
                    for (int i = 1; i < 7; ++i) {
                        ItemStack other2 = this.getStackInSlot(i);
                        if (!soul.m_41619_() && !support.canSupport(TrainingFacilityBlockEntity.this.m_58904_(), stack).test(soul)) {
                            return false;
                        }
                        if (i == slot || other2.m_41619_() || support.canSupport(TrainingFacilityBlockEntity.this.m_58904_(), stack).test(other2)) continue;
                        return false;
                    }
                } else {
                    return false;
                }
                return true;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)ForgeCapabilities.ITEM_HANDLER)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int m_6413_(int index) {
                switch (index) {
                    case 0: {
                        return TrainingFacilityBlockEntity.this.recipeTime;
                    }
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        TrainingFacilityBlockEntity.this.recipeTime = value;
                    }
                }
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    public AbstractContainerMenu m_7208_(int id, Inventory player, Player entity) {
        return new TrainingFacilityContainer(id, player, this, this.tileData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.umapyoi.training_facility");
    }
}

