/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.events.ApplyUmasoulAttributeEvent;
import net.tracen.umapyoi.events.ResumeActionPointEvent;
import net.tracen.umapyoi.events.SettingPropertyEvent;
import net.tracen.umapyoi.registry.UmapyoiAttributesRegistry;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class UmaSoulCuriosWrapper
implements ICurio {
    private final ItemStack stack;

    public UmaSoulCuriosWrapper(ItemStack stack) {
        this.stack = stack;
    }

    public boolean canEquip(SlotContext slotContext) {
        return slotContext.identifier().equals("uma_soul");
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return slotContext.identifier().equals("uma_soul");
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
        return new ICurio.SoundInfo(SoundEvents.f_11678_, 1.0f, 1.0f);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void curioTick(SlotContext slotContext) {
        if (this.getStack().m_41619_()) {
            return;
        }
        if (!slotContext.identifier().equalsIgnoreCase("uma_soul")) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        Level commandSenderWorld = entity.m_20193_();
        if (!commandSenderWorld.m_5776_()) {
            this.resumeActionPoint(entity);
        }
    }

    private void resumeActionPoint(LivingEntity entity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ResumeActionPointEvent(entity, this.stack))) {
            return;
        }
        if (UmaSoulUtils.getActionPoint(this.getStack()) != UmaSoulUtils.getMaxActionPoint(this.getStack())) {
            UmaSoulUtils.setActionPoint(this.getStack(), Math.min(UmaSoulUtils.getActionPoint(this.getStack()) + 1, UmaSoulUtils.getMaxActionPoint(this.getStack())));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
        LinkedHashMultimap atts = LinkedHashMultimap.create();
        LivingEntity user = slotContext.entity();
        if (!slotContext.identifier().equalsIgnoreCase("uma_soul")) {
            return atts;
        }
        CuriosApi.addSlotModifier((Multimap)atts, (String)"uma_suit", (UUID)uuid, (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        if (UmaSoulUtils.getGrowth(this.getStack()) == Growth.UNTRAINED) {
            return atts;
        }
        atts.put((Object)((Attribute)UmapyoiAttributesRegistry.SPRINT_SPEED.get()), (Object)new AttributeModifier(uuid, "sprint_speed_running_bonus", this.getExactProperty(user, UmaStatusUtils.StatusType.SPEED, (Double)UmapyoiConfig.UMASOUL_MAX_SPEED.get()), (Boolean)UmapyoiConfig.UMASOUL_SPEED_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION));
        atts.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(uuid, "speed_swiming_bonus", this.getExactProperty(user, UmaStatusUtils.StatusType.SPEED, (Double)UmapyoiConfig.UMASOUL_MAX_SPEED.get()), (Boolean)UmapyoiConfig.UMASOUL_SPEED_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "strength_attack_bonus", this.getExactProperty(user, UmaStatusUtils.StatusType.STRENGTH, (Double)UmapyoiConfig.UMASOUL_MAX_STRENGTH_ATTACK.get()), (Boolean)UmapyoiConfig.UMASOUL_STRENGTH_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(uuid, "strength_attack_bonus", this.getExactProperty(user, UmaStatusUtils.StatusType.STAMINA, (Double)UmapyoiConfig.UMASOUL_MAX_STAMINA_HEALTH.get()), (Boolean)UmapyoiConfig.UMASOUL_STAMINA_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "guts_armor_bonus", this.getExactProperty(user, UmaStatusUtils.StatusType.GUTS, (Double)UmapyoiConfig.UMASOUL_MAX_GUTS_ARMOR.get()), (Boolean)UmapyoiConfig.UMASOUL_GUTS_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION));
        atts.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "guts_armor_toughness_bonus", this.getExactProperty(user, UmaStatusUtils.StatusType.GUTS, (Double)UmapyoiConfig.UMASOUL_MAX_GUTS_ARMOR_TOUGHNESS.get()), (Boolean)UmapyoiConfig.UMASOUL_GUTS_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION));
        if (user.m_21051_((Attribute)UmapyoiAttributesRegistry.SPRINT_SPEED.get()) != null) {
            atts.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "speed_running_bonus", user.m_20142_() ? user.m_21133_((Attribute)UmapyoiAttributesRegistry.SPRINT_SPEED.get()) : 0.0, (Boolean)UmapyoiConfig.UMASOUL_SPEED_PRECENT_ENABLE.get() != false ? AttributeModifier.Operation.MULTIPLY_TOTAL : AttributeModifier.Operation.ADDITION));
        }
        ApplyUmasoulAttributeEvent event = new ApplyUmasoulAttributeEvent(this.getStack(), slotContext, uuid, (Multimap<Attribute, AttributeModifier>)atts);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getAttributes();
    }

    public double getExactProperty(LivingEntity user, UmaStatusUtils.StatusType status, double limit) {
        int num = status.getId();
        double retiredValue = UmaSoulUtils.getGrowth(this.getStack()) == Growth.RETIRED ? 1.0 : 0.25;
        double propertyRate = 1.0 + (double)UmaSoulUtils.getPropertyRate(this.getStack())[num] / 100.0;
        double totalProperty = this.propertyPercentage(num);
        SettingPropertyEvent event = new SettingPropertyEvent(user, this.getStack(), retiredValue, propertyRate, totalProperty);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResultProperty() * limit;
    }

    private double propertyPercentage(int num) {
        Integer statLimit;
        int x = UmaSoulUtils.getProperty(this.getStack())[num];
        double denominator = 1.0 + Math.pow(Math.E, (x > (statLimit = (Integer)UmapyoiConfig.STAT_LIMIT_VALUE.get()) ? -0.125 * (Double)UmapyoiConfig.STAT_LIMIT_REDUCTION_RATE.get() : -0.125) * (double)(x - statLimit));
        return 1.0 / denominator;
    }
}

