/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.item.ItemRegistry;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class FadedUmaSoulItem
extends Item {
    public FadedUmaSoulItem() {
        super(Umapyoi.defaultItemProperties().m_41487_(1));
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.umapyoi.umadata.name", (Object[])new Object[]{UmaSoulUtils.getTranslatedUmaName(this.getUmaName(pStack))}).m_130940_(ChatFormatting.GRAY));
    }

    public ResourceLocation getUmaName(ItemStack pStack) {
        if (pStack.m_41784_().m_128461_("name").isBlank()) {
            return UmaData.DEFAULT_UMA_ID;
        }
        return Optional.ofNullable(ResourceLocation.m_135820_((String)pStack.m_41784_().m_128461_("name"))).orElse(UmaData.DEFAULT_UMA_ID);
    }

    public Component m_7626_(ItemStack pStack) {
        GachaRanking ranking = GachaRanking.getGachaRanking(pStack);
        if (ranking == GachaRanking.EASTER_EGG) {
            return super.m_7626_(pStack).m_6881_().m_130940_(ChatFormatting.GREEN);
        }
        return super.m_7626_(pStack);
    }

    public Rarity m_41460_(ItemStack pStack) {
        GachaRanking ranking = GachaRanking.getGachaRanking(pStack);
        return ranking == GachaRanking.SSR || ranking == GachaRanking.EASTER_EGG ? Rarity.EPIC : (ranking == GachaRanking.SR ? Rarity.UNCOMMON : Rarity.COMMON);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return this.getUmaName(itemStack).m_135827_();
    }

    public static ItemStack genUmaSoul(String name, UmaData data) {
        ItemStack result = ((Item)ItemRegistry.BLANK_UMA_SOUL.get()).m_7968_();
        result.m_41784_().m_128359_("name", name);
        result.m_41784_().m_128359_("identifier", data.getIdentifier().toString());
        result.m_41784_().m_128359_("ranking", data.getGachaRanking().toString().toLowerCase());
        return result;
    }
}

