/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.item;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.curios.UmaSoulCapProvider;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.registry.umadata.UmaData;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.ResultRankingUtils;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class UmaSoulItem
extends Item {
    private static final Comparator<Holder.Reference<UmaData>> COMPARATOR = new UmaDataComparator();

    public UmaSoulItem() {
        super(Umapyoi.defaultItemProperties().m_41487_(1));
    }

    public static Stream<Holder.Reference<UmaData>> sortedUmaDataList(HolderLookup.Provider provider) {
        return UmapyoiAPI.getUmaDataRegistry(provider).m_214062_().sorted(COMPARATOR);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return UmaSoulUtils.getName(itemStack).m_135827_();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof UmaSoulItem) {
            return new UmaSoulCapProvider(stack);
        }
        return null;
    }

    public Component m_7626_(ItemStack pStack) {
        GachaRanking ranking = GachaRanking.getGachaRanking(pStack);
        if (ranking == GachaRanking.EASTER_EGG) {
            return super.m_7626_(pStack).m_6881_().m_130940_(ChatFormatting.GREEN);
        }
        return super.m_7626_(pStack);
    }

    public Rarity m_41460_(ItemStack pStack) {
        GachaRanking ranking = GachaRanking.getGachaRanking(pStack);
        return ranking == GachaRanking.SSR || ranking == GachaRanking.EASTER_EGG ? Rarity.EPIC : (ranking == GachaRanking.SR ? Rarity.UNCOMMON : Rarity.COMMON);
    }

    public String m_5671_(ItemStack pStack) {
        return Util.m_137492_((String)"umadata", (ResourceLocation)UmaSoulUtils.getName(pStack));
    }

    public boolean m_5812_(ItemStack pStack) {
        return UmaSoulUtils.getGrowth(pStack) == Growth.RETIRED;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        int ranking = ResultRankingUtils.getRanking(stack);
        if (UmaSoulUtils.getGrowth(stack) == Growth.TRAINED && UmaSoulUtils.getPhysique(stack) <= 0) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.umapyoi.uma_soul.should_retire", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(ranking)}).m_130940_(ChatFormatting.GRAY));
        }
        if (UmaSoulUtils.getGrowth(stack) == Growth.RETIRED) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.umapyoi.uma_soul.ranking", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(ranking)}).m_130940_(ChatFormatting.GOLD));
        }
        if (Screen.m_96638_() || !((Boolean)UmapyoiConfig.TOOLTIP_SWITCH.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.umapyoi.uma_soul.soul_details").m_130940_(ChatFormatting.AQUA));
            int[] property = UmaSoulUtils.getProperty(stack);
            int[] maxProperty = UmaSoulUtils.getMaxProperty(stack);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.umapyoi.uma_soul.speed_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property[UmaStatusUtils.StatusType.SPEED.getId()]), UmaStatusUtils.getStatusLevel(maxProperty[UmaStatusUtils.StatusType.SPEED.getId()])}).m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.umapyoi.uma_soul.stamina_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property[UmaStatusUtils.StatusType.STAMINA.getId()]), UmaStatusUtils.getStatusLevel(maxProperty[UmaStatusUtils.StatusType.STAMINA.getId()])}).m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.umapyoi.uma_soul.strength_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property[UmaStatusUtils.StatusType.STRENGTH.getId()]), UmaStatusUtils.getStatusLevel(maxProperty[UmaStatusUtils.StatusType.STRENGTH.getId()])}).m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.umapyoi.uma_soul.guts_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property[UmaStatusUtils.StatusType.GUTS.getId()]), UmaStatusUtils.getStatusLevel(maxProperty[UmaStatusUtils.StatusType.GUTS.getId()])}).m_130940_(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.umapyoi.uma_soul.wisdom_details", (Object[])new Object[]{UmaStatusUtils.getStatusLevel(property[UmaStatusUtils.StatusType.WISDOM.getId()]), UmaStatusUtils.getStatusLevel(maxProperty[UmaStatusUtils.StatusType.WISDOM.getId()])}).m_130940_(ChatFormatting.DARK_GREEN));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.umapyoi.press_shift_for_details").m_130940_(ChatFormatting.AQUA));
        }
    }

    private static class UmaDataComparator
    implements Comparator<Holder.Reference<UmaData>> {
        private UmaDataComparator() {
        }

        @Override
        public int compare(Holder.Reference<UmaData> left, Holder.Reference<UmaData> right) {
            GachaRanking rightRanking;
            GachaRanking leftRanking = ((UmaData)left.m_203334_()).getGachaRanking();
            if (leftRanking == (rightRanking = ((UmaData)right.m_203334_()).getGachaRanking())) {
                String leftName = left.m_205785_().m_135782_().toString();
                String rightName = right.m_205785_().m_135782_().toString();
                return leftName.compareToIgnoreCase(rightName);
            }
            return leftRanking.compareTo(rightRanking);
        }
    }
}

