/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.mixin;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.api.UmapyoiAPI;
import net.tracen.umapyoi.registry.umadata.Growth;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=10)
public class PlayerFoodExhaustionMixin {
    @Inject(method={"causeFoodExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void foodExhaustion(float pExhaustion, CallbackInfo ci) {
        Player player = (Player)this;
        ItemStack umaSoul = UmapyoiAPI.getUmaSoul((LivingEntity)player);
        if (!umaSoul.m_41619_()) {
            if (!player.m_150110_().f_35934_ && !player.m_9236_().m_5776_()) {
                float exhaustionMultipler = 1.2f - this.getExactProperty(umaSoul, UmaStatusUtils.StatusType.STAMINA.getId(), 0.85f);
                player.m_36324_().m_38703_(pExhaustion * exhaustionMultipler);
            }
            ci.cancel();
        }
    }

    private float getExactProperty(ItemStack stack, int num, double limit) {
        double retiredValue = UmaSoulUtils.getGrowth(stack) == Growth.RETIRED ? 1.0 : 0.25;
        double totalProperty = this.propertyPercentage(stack, num);
        return (float)((double)UmaSoulUtils.getMotivation(stack).getMultiplier() * limit * retiredValue * totalProperty);
    }

    private double propertyPercentage(ItemStack stack, int num) {
        Integer statLimit;
        int x = UmaSoulUtils.getProperty(stack)[num];
        double denominator = 1.0 + Math.pow(Math.E, (x > (statLimit = (Integer)UmapyoiConfig.STAT_LIMIT_VALUE.get()) ? -0.125 * (Double)UmapyoiConfig.STAT_LIMIT_REDUCTION_RATE.get() : -0.125) * (double)(x - statLimit));
        return 1.0 / denominator;
    }
}

