/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.Umapyoi;
import net.tracen.umapyoi.utils.GachaRanking;
import net.tracen.umapyoi.utils.UmaSoulUtils;

public class RequestUma {
    private final Optional<ResourceLocation> name;
    private final Optional<ResourceLocation> identifier;
    private final List<GachaRanking> ranking;
    public static final Codec<RequestUma> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("name").forGetter(RequestUma::getName), (App)ResourceLocation.f_135803_.optionalFieldOf("identifier").forGetter(RequestUma::getIdentifier), (App)GachaRanking.CODEC.listOf().optionalFieldOf("ranking", (Object)Lists.newArrayList()).forGetter(RequestUma::getRanking)).apply((Applicative)instance, RequestUma::new));

    public RequestUma() {
        this.name = Optional.empty();
        this.identifier = Optional.empty();
        this.ranking = Lists.newArrayList();
    }

    public RequestUma(Optional<ResourceLocation> name, Optional<ResourceLocation> identifier, List<GachaRanking> ranking) {
        this.name = name;
        this.identifier = identifier;
        this.ranking = ranking;
    }

    public Optional<ResourceLocation> getName() {
        return this.name;
    }

    public Optional<ResourceLocation> getIdentifier() {
        return this.identifier;
    }

    public List<GachaRanking> getRanking() {
        return this.ranking;
    }

    public static RequestUma fromJSON(JsonObject json) {
        return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(msg -> Umapyoi.getLogger().error("Failed to parse : {}", msg)).orElseGet(RequestUma::new);
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).resultOrPartial(msg -> Umapyoi.getLogger().error("Failed to encode : {}", msg)).orElseThrow();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        String utf = this.toJson().toString();
        buffer.m_130070_(utf);
    }

    public static RequestUma fromNetwork(FriendlyByteBuf buffer) {
        String utf = buffer.m_130277_();
        return RequestUma.fromJSON(JsonParser.parseString((String)utf).getAsJsonObject());
    }

    public boolean test(ItemStack soul) {
        boolean name = this.name.isPresent() ? UmaSoulUtils.getName(soul).equals((Object)this.name.get()) : true;
        boolean id = this.identifier.isPresent() ? ResourceLocation.m_135820_((String)soul.m_41784_().m_128461_("identifier")).equals((Object)this.identifier.get()) : true;
        boolean ranking = !this.ranking.isEmpty() ? this.ranking.contains((Object)GachaRanking.getGachaRanking(soul)) : true;
        return name && id && ranking;
    }

    public void initItemStack(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        this.name.ifPresent(loc -> tag.m_128359_("name", loc.toString()));
        this.identifier.ifPresent(loc -> tag.m_128359_("identifier", loc.toString()));
    }
}

