/*
 * Decompiled with CFR 0.152.
 */
package net.tracen.umapyoi.registry.training;

import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.tracen.umapyoi.UmapyoiConfig;
import net.tracen.umapyoi.registry.training.SupportStack;
import net.tracen.umapyoi.registry.training.TrainingSupport;
import net.tracen.umapyoi.utils.UmaSoulUtils;
import net.tracen.umapyoi.utils.UmaStatusUtils;

public class BorealisSupport
extends TrainingSupport {
    @Override
    public Component getDescription(SupportStack stack) {
        return this.getDescription();
    }

    @Override
    public boolean applySupport(ItemStack soul, RandomSource rand, SupportStack stack) {
        float chance = rand.m_188501_();
        if ((double)chance < (Double)UmapyoiConfig.ACUPUNCTUIST_SUPPORT_CHANCE.get()) {
            this.applySuccessEvent(soul, rand);
        } else {
            UmaStatusUtils.downMotivation(soul);
        }
        return true;
    }

    public void applySuccessEvent(ItemStack soul, RandomSource rand) {
        switch (AcupuncturistEventTypes.getRandomType(rand)) {
            case STATUS: {
                for (int i = 0; i < 5; ++i) {
                    UmaSoulUtils.getMaxProperty((ItemStack)soul)[i] = Math.min(39, UmaSoulUtils.getMaxProperty(soul)[i] + 1);
                    if (UmaSoulUtils.getMaxProperty(soul)[i] <= UmaSoulUtils.getProperty(soul)[i]) continue;
                    UmaSoulUtils.getProperty((ItemStack)soul)[i] = Math.min(UmaSoulUtils.getMaxProperty(soul)[i], UmaSoulUtils.getProperty(soul)[i] + 1);
                }
                break;
            }
            case PHYSIQUE: {
                int phy = Math.min(UmaSoulUtils.getPhysique(soul) + 1, 5);
                UmaSoulUtils.setPhysique(soul, phy);
                break;
            }
            case MOTIVATION: {
                UmaStatusUtils.addMotivation(soul);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + AcupuncturistEventTypes.getRandomType(rand));
            }
        }
    }

    public static enum AcupuncturistEventTypes {
        STATUS,
        PHYSIQUE,
        MOTIVATION;


        public static AcupuncturistEventTypes getRandomType(RandomSource rand) {
            return AcupuncturistEventTypes.values()[rand.m_188503_(AcupuncturistEventTypes.values().length)];
        }
    }
}

