/*
 * Decompiled with CFR 0.152.
 */
package me.katanya04.minespawners.config;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.katanya04.minespawners.config.ConfigScreen;
import me.katanya04.minespawners.config.PickaxeButton;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8132;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class PickaxesList
extends class_4265<Entry> {
    public static final int BUTTON_SIZE = 20;
    public static final int BUTTON_MARGIN = 10;
    private final ConfigScreen configScreen;

    public PickaxesList(ConfigScreen configScreen, class_310 minecraft) {
        super(minecraft, configScreen.field_22789, configScreen.field_49503.method_57727() - (configScreen.slider.method_57701(null).method_25364() + 10), configScreen.field_49503.method_48998() + configScreen.slider.method_57701(null).method_25364() + 10, 30);
        this.configScreen = configScreen;
        this.setEntries();
    }

    protected void setEntries() {
        this.method_25339();
        this.method_25321((class_350.class_351)new TitleEntry((class_2561)class_2561.method_43471((String)"config.blacklisted_pickaxes")));
        int initialX = (this.method_25322() - this.getButtonsPerRow() * 30 + 10) / 2 + 25;
        for (int i = 0; i < this.configScreen.pickaxes.size(); i += this.getButtonsPerRow()) {
            this.method_25321((class_350.class_351)new RowEntry(this, this.configScreen.pickaxes.subList(i, Math.min(i + this.getButtonsPerRow(), this.configScreen.pickaxes.size())), initialX));
        }
    }

    public void method_57712(int width, class_8132 layout) {
        this.method_57714(width, layout.method_57727() - (this.configScreen.slider.method_57701(null).method_25364() + 10), layout.method_48998() + this.configScreen.slider.method_57701(null).method_25364() + 10);
        this.setEntries();
        this.method_65506();
    }

    public int method_25322() {
        return this.configScreen.field_22789 - 50;
    }

    public int getButtonsPerRow() {
        return this.method_25322() / 30;
    }

    @Environment(value=EnvType.CLIENT)
    public class TitleEntry
    extends Entry {
        final class_2561 title;
        private final int width;

        public TitleEntry(class_2561 title) {
            this.title = title;
            this.width = ((PickaxesList)PickaxesList.this).field_22740.field_1772.method_27525((class_5348)this.title);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, TitleEntry.this.title);
                }
            });
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            class_327 class_3272 = ((PickaxesList)PickaxesList.this).field_22740.field_1772;
            int n = PickaxesList.this.field_22758 / 2 - this.width / 2;
            int n2 = this.method_46427() + this.method_25364() / 2;
            Objects.requireNonNull(((PickaxesList)PickaxesList.this).field_22740.field_1772);
            context.method_51439(class_3272, this.title, n, n2 - 9 / 2, -1, true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class RowEntry
    extends Entry {
        private final PickaxeButton[] buttons;

        public RowEntry(PickaxesList this$0, List<class_1792> pickaxes, int initialX) {
            this.buttons = new PickaxeButton[pickaxes.size()];
            int x = initialX;
            int i = 0;
            for (class_1792 pickaxe : pickaxes) {
                this.buttons[i++] = new PickaxeButton(x, 0, 20, pickaxe, (class_437)this$0.configScreen);
                x += 30;
            }
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return Arrays.asList(this.buttons);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Arrays.asList(this.buttons);
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            Arrays.stream(this.buttons).forEach(b -> {
                b.method_46419(this.method_46427());
                b.method_25394(context, mouseX, mouseY, deltaTicks);
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
    }
}

