/*
 * Decompiled with CFR 0.152.
 */
package me.katanya04.minespawners.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.katanya04.minespawners.Main;
import me.katanya04.minespawners.config.valuetypes.ConfigValue;
import me.katanya04.minespawners.config.valuetypes.FloatConfigValue;
import me.katanya04.minespawners.config.valuetypes.ListConfigValue;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_9424;

public class SimpleConfig {
    public static final Map<String, ConfigValue<?>> values = new HashMap();
    private static final File configFile = new File("config" + File.separator + "minespawners-config.json");
    public static FloatConfigValue DROP_CHANCE = new FloatConfigValue("DROP_CHANCE", Float.valueOf(1.0f), 0.0f, 1.0f);
    public static ListConfigValue<String> BLACKLISTED_PICKAXES = new ListConfigValue<String>("BLACKLISTED_PICKAXES", new ArrayList(), SimpleConfig::isPickaxe){

        @Override
        public Codec<List<String>> getCodec() {
            return Codec.STRING.listOf().xmap(ArrayList::new, Collections::unmodifiableList);
        }
    };

    private static boolean checkIfConfigExists() {
        return configFile.isFile() && configFile.exists() && configFile.canRead() && configFile.canWrite();
    }

    private static boolean createFile(boolean override) {
        try {
            if (SimpleConfig.checkIfConfigExists() && !override) {
                return false;
            }
            configFile.delete();
            configFile.getParentFile().mkdirs();
            return configFile.createNewFile();
        }
        catch (IOException ioException) {
            throw new RuntimeException("IO exception while creating config file for minespawners mod: " + String.valueOf(ioException));
        }
    }

    private static void readValuesFromFile() {
        try {
            String jsonString = new String(Files.readAllBytes(configFile.toPath()));
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            values.forEach((k, v) -> {
                try {
                    v.setValueFromJson(json);
                }
                catch (Exception exception) {
                    Log.warn((LogCategory)Main.logCategory, (String)("Malformed entry for " + v.getKey() + " configuration value. Correcting"));
                }
            });
            configFile.delete();
            Files.writeString(configFile.toPath(), (CharSequence)new Gson().toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new RuntimeException("IO exception while reading config file for minespawners mod: " + String.valueOf(ioException));
        }
    }

    public static void saveToFile() {
        try {
            String jsonString = new String(Files.readAllBytes(configFile.toPath()));
            JsonElement jsonElement = JsonParser.parseString((String)jsonString);
            JsonObject json = jsonElement.isJsonNull() ? new JsonObject() : jsonElement.getAsJsonObject();
            values.forEach((k, v) -> v.setValueToJson(json));
            configFile.delete();
            Files.writeString(configFile.toPath(), (CharSequence)new Gson().toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new RuntimeException("IO exception while saving config file for minespawners mod: " + String.valueOf(ioException));
        }
    }

    static Set<class_1792> getAllPickaxes() {
        return class_7923.field_41178.method_10220().filter(item -> SimpleConfig.isPickaxe(item.method_7854())).collect(Collectors.toSet());
    }

    private static boolean isPickaxe(String name) {
        return SimpleConfig.isPickaxe(((class_1792)class_7923.field_41178.method_63535(class_2960.method_12829((String)name))).method_7854());
    }

    private static boolean isPickaxe(class_1799 stack) {
        return stack.method_31573(class_3489.field_42614) || stack.method_7951(class_2246.field_10260.method_9564()) || stack.method_58694(class_9334.field_50077) != null && ((class_9424)stack.method_58694(class_9334.field_50077)).comp_2498().stream().anyMatch(r -> {
            class_6885.class_6888 blocks;
            class_6885 patt0$temp = r.comp_2501();
            return patt0$temp instanceof class_6885.class_6888 && (blocks = (class_6885.class_6888)patt0$temp).method_40251().comp_327().equals((Object)class_3481.field_33715.comp_327());
        });
    }

    public static void initializeConfig() {
        values.put(DROP_CHANCE.getKey(), DROP_CHANCE);
        values.put(BLACKLISTED_PICKAXES.getKey(), BLACKLISTED_PICKAXES);
        if (!SimpleConfig.createFile(false)) {
            SimpleConfig.readValuesFromFile();
        }
        SimpleConfig.saveToFile();
    }
}

