/*
 * Decompiled with CFR 0.152.
 */
package me.katanya04.minespawners.config.valuetypes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T> {
    protected final String key;
    protected T value;
    @Nullable
    protected final Predicate<T> checker;

    public ConfigValue(String key, T defValue) {
        this(key, defValue, null);
    }

    public ConfigValue(String key, T defValue, @Nullable Predicate<T> checker) {
        this.key = key;
        this.value = defValue;
        this.checker = checker;
    }

    public String getKey() {
        return this.key;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(@NotNull T value) {
        if (this.checker == null || this.checker.test(value)) {
            this.value = value;
        }
    }

    public void setValueFromJson(@NotNull JsonObject json) {
        Object newValue = this.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get(this.getKey())).getOrThrow();
        this.setValue(newValue);
    }

    public void setValueToJson(@NotNull JsonObject json) {
        json.add(this.getKey(), (JsonElement)this.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, this.value).getOrThrow());
    }

    public String toString() {
        return this.getKey() + ": " + String.valueOf(this.value);
    }

    public abstract Codec<T> getCodec();
}

