/*
 * Decompiled with CFR 0.152.
 */
package me.katanya04.minespawners.config.valuetypes;

import java.util.List;
import java.util.function.Predicate;
import me.katanya04.minespawners.config.valuetypes.ConfigValue;
import org.jetbrains.annotations.Nullable;

public abstract class ListConfigValue<T>
extends ConfigValue<List<T>> {
    @Nullable
    protected final Predicate<T> entryChecker;

    public ListConfigValue(String key, List<T> defValue) {
        this(key, defValue, (Predicate<T>)null);
    }

    public ListConfigValue(String key, List<T> defValue, @Nullable Predicate<T> entryChecker) {
        this(key, defValue, entryChecker, null);
    }

    public ListConfigValue(String key, List<T> defValue, @Nullable Predicate<T> entryChecker, @Nullable Predicate<List<T>> checker) {
        super(key, defValue, checker);
        this.entryChecker = entryChecker;
    }

    public void addValue(T value) {
        if (this.entryChecker == null || this.entryChecker.test(value)) {
            ((List)this.value).add(value);
        }
    }

    public boolean removeValue(T value) {
        return ((List)this.value).remove(value);
    }

    public boolean contains(T value) {
        return ((List)this.value).contains(value);
    }
}

