/*
 * Decompiled with CFR 0.152.
 */
package me.katanya04.minespawners.loot.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.katanya04.minespawners.loot.LootRegistration;
import net.minecraft.class_11580;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_169;
import net.minecraft.class_1799;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_3542;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5651;
import net.minecraft.class_5652;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class CopyDataComponentFunction
extends class_120 {
    public static final MapCodec<CopyDataComponentFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyDataComponentFunction.method_53344((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_5652.field_45882.fieldOf("source").forGetter(function -> function.source), (App)class_7923.field_41181.method_39673().fieldOf("blockEntityType").forGetter(function -> function.blockEntityType), (App)CopyOperation.CODEC.listOf().fieldOf("ops").forGetter(function -> function.operations))).apply((Applicative)instance, CopyDataComponentFunction::new));
    private final class_5651 source;
    private final class_2591<?> blockEntityType;
    private final List<CopyOperation> operations;

    CopyDataComponentFunction(List<class_5341> conditions, class_5651 source, class_2591<?> blockEntityType, List<CopyOperation> operations) {
        super(conditions);
        this.source = source;
        this.blockEntityType = blockEntityType;
        this.operations = List.copyOf(operations);
    }

    @NotNull
    public class_5339<CopyDataComponentFunction> method_29321() {
        return LootRegistration.copyDataComponentFunctionType;
    }

    public Set<class_169<?>> method_293() {
        return this.source.method_32441();
    }

    public class_1799 method_522(class_1799 item, class_47 context) {
        class_2520 sourceTag = this.source.method_32440(context);
        if (sourceTag == null) {
            return item;
        }
        HashMap<class_9331, class_11580> tags = new HashMap<class_9331, class_11580>();
        this.operations.forEach(op -> {
            if (!tags.containsKey(op.ComponentType)) {
                tags.put(op.ComponentType, (class_11580)item.method_58695(op.ComponentType, (Object)class_11580.method_72535((Object)class_9334.field_49611, (class_2487)class_9279.field_49302.method_57461())));
            }
            op.apply(tags, sourceTag, this.blockEntityType);
        });
        tags.forEach((arg_0, arg_1) -> ((class_1799)item).method_57379(arg_0, arg_1));
        return item;
    }

    public static Builder builder(class_5651 source, class_2591<?> blockEntityType) {
        return new Builder(source, blockEntityType);
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final class_5651 source;
        private final class_2591<?> blockEntityType;
        private final List<CopyOperation> ops = Lists.newArrayList();

        Builder(class_5651 source, class_2591<?> blockEntityType) {
            this.source = source;
            this.blockEntityType = blockEntityType;
        }

        public Builder withOperation(String sourcePath, String targetPath, MergeStrategy operator, class_9331<class_11580<class_2591<?>>> ComponentType) {
            try {
                this.ops.add(new CopyOperation(class_2203.class_2209.method_58472((String)sourcePath), class_2203.class_2209.method_58472((String)targetPath), operator, ComponentType));
                return this;
            }
            catch (CommandSyntaxException var5) {
                throw new IllegalArgumentException(var5);
            }
        }

        public Builder withOperation(String source, String target, class_9331<class_11580<class_2591<?>>> ComponentType) {
            return this.withOperation(source, target, MergeStrategy.REPLACE, ComponentType);
        }

        @NotNull
        protected Builder getThisBuilder() {
            return this;
        }

        @NotNull
        public class_117 method_515() {
            return new CopyDataComponentFunction(this.method_526(), this.source, this.blockEntityType, this.ops);
        }
    }

    record CopyOperation(class_2203.class_2209 sourcePath, class_2203.class_2209 targetPath, MergeStrategy op, class_9331<class_11580<class_2591<?>>> ComponentType) {
        public static final Codec<CopyOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2203.class_2209.field_50034.fieldOf("source").forGetter(CopyOperation::sourcePath), (App)class_2203.class_2209.field_50034.fieldOf("target").forGetter(CopyOperation::targetPath), (App)MergeStrategy.CODEC.fieldOf("op").forGetter(CopyOperation::op), (App)class_9331.field_49600.fieldOf("ComponentType").forGetter(CopyOperation::ComponentType)).apply((Applicative)instance, (nbtPath, nbtPath2, mergeStrategy, ComponentType1) -> new CopyOperation((class_2203.class_2209)nbtPath, (class_2203.class_2209)nbtPath2, (MergeStrategy)((Object)((Object)mergeStrategy)), (class_9331<class_11580<class_2591<?>>>)ComponentType1)));

        public void apply(HashMap<class_9331<class_11580<class_2591<?>>>, class_11580<class_2591<?>>> tags, class_2520 sourceTag, class_2591<?> blockEntityType) {
            try {
                List sourceNBT = this.sourcePath.method_9366(sourceTag);
                if (!sourceNBT.isEmpty()) {
                    this.op.merge(tags, this.ComponentType, this.targetPath, sourceNBT, blockEntityType);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public static enum MergeStrategy implements class_3542
    {
        REPLACE("replace"){

            @Override
            public void merge(HashMap<class_9331<class_11580<class_2591<?>>>, class_11580<class_2591<?>>> tags, class_9331<class_11580<class_2591<?>>> ComponentType, class_2203.class_2209 targetPath, List<class_2520> sourceNbts, class_2591<?> blockEntityType) throws CommandSyntaxException {
                class_2520 newValue = ((class_2520)Iterables.getLast(sourceNbts)).method_10707();
                tags.put(ComponentType, class_11580.method_72535(blockEntityType, (class_2487)((class_2487)newValue.method_68571().get())));
                targetPath.method_35722((class_2520)tags.get(ComponentType).method_72540(), newValue);
            }
        }
        ,
        APPEND("append"){

            @Override
            public void merge(HashMap<class_9331<class_11580<class_2591<?>>>, class_11580<class_2591<?>>> tags, class_9331<class_11580<class_2591<?>>> ComponentType, class_2203.class_2209 targetPath, List<class_2520> sourceNbts, class_2591<?> blockEntityType) throws CommandSyntaxException {
                List list = targetPath.method_9367((class_2520)tags.get(ComponentType).method_72540(), class_2499::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof class_2499) {
                        sourceNbts.forEach(sourceNbt -> ((class_2499)foundNbt).add((Object)sourceNbt.method_10707()));
                    }
                });
            }
        }
        ,
        MERGE("merge"){

            @Override
            public void merge(HashMap<class_9331<class_11580<class_2591<?>>>, class_11580<class_2591<?>>> tags, class_9331<class_11580<class_2591<?>>> ComponentType, class_2203.class_2209 targetPath, List<class_2520> sourceNbts, class_2591<?> blockEntityType) throws CommandSyntaxException {
                List list = targetPath.method_9367((class_2520)tags.get(ComponentType).method_72540(), class_2487::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof class_2487) {
                        sourceNbts.forEach(sourceNbt -> {
                            if (sourceNbt instanceof class_2487) {
                                ((class_2487)foundNbt).method_10543((class_2487)sourceNbt);
                            }
                        });
                    }
                });
            }
        };

        public static final Codec<MergeStrategy> CODEC;
        private final String name;

        public abstract void merge(HashMap<class_9331<class_11580<class_2591<?>>>, class_11580<class_2591<?>>> var1, class_9331<class_11580<class_2591<?>>> var2, class_2203.class_2209 var3, List<class_2520> var4, class_2591<?> var5) throws CommandSyntaxException;

        private MergeStrategy(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(MergeStrategy::values);
        }
    }
}

