/*
 * Decompiled with CFR 0.152.
 */
package de.saschat.journeylocator;

import de.saschat.journeylocator.TrackedPlayerContainer;
import de.saschat.journeylocator.network.SourceDistinction;
import de.saschat.journeylocator.network.subpackets.ClientboundTrackedPlayerPacket;
import de.saschat.journeylocator.network.subpackets.ClientboundTrackerResetPacket;
import de.saschat.journeylocator.network.subpackets.HandshakePacket;
import de.saschat.journeylocator.network.subpackets.XaeroSubpacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.common.network.model.PlayerLocation;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class JourneyLocator {
    public static final String MOD_ID = "journeylocator";
    public static final ResourceLocation XAERO_PACKETS = ResourceLocation.parse((String)"xaerominimap:main");
    public static BiConsumer<SourceDistinction, XaeroSubpacket> SUBPACKET_CONSUMER;
    private static final Logger log;
    private static boolean ENABLED;
    private static ResourceKey<Level> level;

    private static void sendPacket(SourceDistinction to, XaeroSubpacket packet) {
        log.info("Sending {} to {}", (Object)packet.getClass().toString(), (Object)to.name());
        SUBPACKET_CONSUMER.accept(to, packet);
    }

    public static void init() {
    }

    private static void jm_remove(UUID uuid) {
        PlayerRadarManager.getInstance().remove(uuid);
        DataCache.INSTANCE.removePlayer(uuid.toString());
    }

    private static void jm_update(PlayerLocation loc) {
        JourneymapClient.getInstance().getPacketHandler().onPlayerLocationPacket(loc);
    }

    public static void packet(SourceDistinction ps, XaeroSubpacket x) {
        if (x.getClass() != ClientboundTrackedPlayerPacket.class) {
            log.info("Received {} from {}", (Object)x.getClass().getSimpleName(), (Object)ps.name());
        }
        XaeroSubpacket xaeroSubpacket = x;
        Objects.requireNonNull(xaeroSubpacket);
        XaeroSubpacket xaeroSubpacket2 = xaeroSubpacket;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HandshakePacket.class, ClientboundTrackedPlayerPacket.class, ClientboundTrackerResetPacket.class}, (Object)xaeroSubpacket2, n)) {
            case 0: {
                HandshakePacket hp = (HandshakePacket)xaeroSubpacket2;
                JourneyLocator.sendPacket(ps, hp);
                break;
            }
            case 1: {
                ClientboundTrackedPlayerPacket tp = (ClientboundTrackedPlayerPacket)xaeroSubpacket2;
                if (!ENABLED) {
                    return;
                }
                if (tp.remove()) {
                    JourneyLocator.jm_remove(tp.id());
                    TrackedPlayerContainer.removeTracking(tp.id());
                    break;
                }
                TrackedPlayerContainer.receiveTracking(tp.id(), tp.pos().get());
                JourneyLocator.jm_update(tp.pos().get());
                break;
            }
            case 2: {
                ClientboundTrackerResetPacket tr = (ClientboundTrackerResetPacket)xaeroSubpacket2;
                if (!ENABLED) {
                    return;
                }
                for (UUID key : TrackedPlayerContainer.getKeys()) {
                    JourneyLocator.jm_remove(key);
                }
                TrackedPlayerContainer.reset();
                break;
            }
        }
    }

    public static void reportPlayer(UUID uuid, int id) {
    }

    public static void setState(boolean b) {
        log.info("Mod set to state: {}", (Object)b);
        ENABLED = b;
    }

    public static void reset() {
        log.info("Resetting mod state");
        JourneyLocator.setState(true);
        level = null;
    }

    public static void changeLevel(ResourceKey<Level> to) {
        if (!ENABLED) {
            return;
        }
        ResourceKey<Level> old = level;
        level = to;
        Object tmp = "";
        if (old != null) {
            tmp = " from " + old.location().toString();
        }
        log.info("Changing level{} to {}", tmp, (Object)to.location().toString());
        if (old != null && !old.equals(to)) {
            for (Map.Entry<UUID, TrackedPlayerContainer.Position> p : TrackedPlayerContainer.getPlayers().entrySet()) {
                if (p.getValue().dimension().equals(old)) {
                    JourneyLocator.jm_remove(p.getKey());
                }
                if (!p.getValue().dimension().equals(to)) continue;
                JourneyLocator.jm_update(p.getValue());
            }
        }
    }

    public static boolean getState() {
        return ENABLED;
    }

    static {
        log = LogManager.getLogger();
        ENABLED = true;
        level = null;
    }
}

