/*
 * Decompiled with CFR 0.152.
 */
package de.saschat.journeylocator.network.subpackets;

import de.saschat.journeylocator.network.subpackets.ClientboundRulesPacket;
import de.saschat.journeylocator.network.subpackets.ClientboundTrackedPlayerPacket;
import de.saschat.journeylocator.network.subpackets.ClientboundTrackerResetPacket;
import de.saschat.journeylocator.network.subpackets.HandshakePacket;
import de.saschat.journeylocator.network.subpackets.LevelMapPropertiesPacket;
import de.saschat.journeylocator.network.subpackets.XaeroSubpacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;

public enum XaeroTypes {
    LEVEL_MAP_PROPERTIES(0, LevelMapPropertiesPacket::read, LevelMapPropertiesPacket::write, LevelMapPropertiesPacket.class),
    HANDSHAKE(1, HandshakePacket::read, HandshakePacket::write, HandshakePacket.class),
    TRACKED_PLAYER(2, ClientboundTrackedPlayerPacket::read, ClientboundTrackedPlayerPacket::write, ClientboundTrackedPlayerPacket.class),
    TRACKER_RESET(3, ClientboundTrackerResetPacket::read, ClientboundTrackerResetPacket::write, ClientboundTrackerResetPacket.class),
    RULES(4, ClientboundRulesPacket::read, ClientboundRulesPacket::write, ClientboundRulesPacket.class);

    int id;
    Function<FriendlyByteBuf, XaeroSubpacket> read;
    BiConsumer<XaeroSubpacket, FriendlyByteBuf> write;
    Class clz;

    private <T extends XaeroSubpacket> XaeroTypes(int id, Function<FriendlyByteBuf, T> read, BiConsumer<T, FriendlyByteBuf> write, Class<T> clz) {
        this.id = id;
        this.write = write;
        this.read = read;
        this.clz = clz;
    }

    public static void write(XaeroSubpacket packet, FriendlyByteBuf buf) {
        for (XaeroTypes value : XaeroTypes.values()) {
            if (value.clz != packet.getClass()) continue;
            buf.writeByte((int)((byte)value.id));
            value.write.accept(packet, buf);
        }
    }

    public static XaeroSubpacket read(FriendlyByteBuf buf) {
        byte id = buf.readByte();
        for (XaeroTypes value : XaeroTypes.values()) {
            if (value.id != id) continue;
            XaeroSubpacket x = value.read.apply(buf);
            return x;
        }
        return null;
    }
}

