/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.armor;

import com.pekar.angelblock.items.ItemRegistry;
import com.pekar.angelblock.utils.Utils;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;

public class ModArmorMaterial {
    private final ArmorMaterial material;
    private final String materialName;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorType, Integer> armorResistanceMap;
    private final int enchantmentValue;
    private final float toughness;
    private final float knockbackResistance;
    private final Holder<SoundEvent> equipmentSound;
    private final TagKey<Item> repairIngredient;
    private final boolean isFireResistant;
    public static final String RENDELITHIC_MATERIAL_NAME = "rendelithic";
    public static final String LIMONITE_MATERIAL_NAME = "limonite";
    public static final String DIAMITHIC_MATERIAL_NAME = "diamithic";
    public static final String LAPIS_MATERIAL_NAME = "lapis";
    public static final String SUPER_MATERIAL_NAME = "super";
    public static final String FLYING_MATERIAL_NAME = "flying";
    protected static final ModArmorMaterial RENDELITHIC = new ModArmorMaterial("rendelithic", "rendelithic_armor", ModArmorMaterial.createArmorTypeMap(3, 7, 9, 3, 7), 25, 0.0f, 0.0f, 11, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, ItemRegistry.RENDELITHIC_INGOT_TAG, true);
    protected static final ModArmorMaterial LIMONITE = new ModArmorMaterial("limonite", "limonite_armor", ModArmorMaterial.createArmorTypeMap(2, 5, 7, 3, 3), 30, 1.0f, 0.0f, 23, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, ItemRegistry.LIMONITE_INGOT_TAG, false);
    protected static final ModArmorMaterial LAPIS = new ModArmorMaterial("lapis", "lapis_armor", ModArmorMaterial.createArmorTypeMap(3, 6, 8, 3, 11), 10, 0.0f, 0.0f, 40, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, ItemRegistry.LAPIS_INGOT_TAG, false);
    protected static final ModArmorMaterial DIAMITHIC = new ModArmorMaterial("diamithic", "diamithic_armor", ModArmorMaterial.createArmorTypeMap(3, 7, 9, 3, 11), 14, 3.0f, 0.2f, 45, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, ItemRegistry.DIAMITHIC_INGOT_TAG, false);
    protected static final ModArmorMaterial SUPER = new ModArmorMaterial("super", "super_armor", ModArmorMaterial.createArmorTypeMap(5, 9, 11, 5, 15), 1, 4.0f, 0.2f, 43, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, ItemRegistry.SUPER_INGOT_TAG, true);
    protected static final ModArmorMaterial FLYING = new ModArmorMaterial("flying", "flying_armor", ModArmorMaterial.createArmorTypeMap(1, 2, 3, 1, 1), 1, 0.0f, 0.0f, 3, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_ELYTRA, ItemRegistry.FLYING_INGOT_TAG, false);
    protected static final ModArmorMaterial RENDELITHIC2 = ModArmorMaterial.copyOf(RENDELITHIC, "rendelithic_armor2");
    protected static final ModArmorMaterial LIMONITE2 = ModArmorMaterial.copyOf(LIMONITE, "limonite_armor2");
    protected static final ModArmorMaterial DIAMITHIC2 = ModArmorMaterial.copyOf(DIAMITHIC, "diamithic_armor2");
    protected static final ModArmorMaterial LAPIS2 = ModArmorMaterial.copyOf(LAPIS, "lapis_armor2");
    protected static final ModArmorMaterial SUPER2 = ModArmorMaterial.copyOf(SUPER, "super_armor2");

    public ModArmorMaterial(String materialName, String armorModelName, EnumMap<ArmorType, Integer> armorResistanceMap, int enchantmentValue, float toughness, float knockbackResistance, int durabilityMultiplier, Holder<SoundEvent> equipmentSound, TagKey<Item> repairIngredient, boolean isFireResistant) {
        this.material = ModArmorMaterial.createVanillaMaterial(armorModelName, durabilityMultiplier, armorResistanceMap, enchantmentValue, equipmentSound, toughness, knockbackResistance, repairIngredient);
        this.materialName = materialName;
        this.armorResistanceMap = armorResistanceMap;
        this.enchantmentValue = enchantmentValue;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.durabilityMultiplier = durabilityMultiplier;
        this.equipmentSound = equipmentSound;
        this.repairIngredient = repairIngredient;
        this.isFireResistant = isFireResistant;
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public boolean isFireResistant() {
        return this.isFireResistant;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModArmorMaterial)) {
            return false;
        }
        ModArmorMaterial another = (ModArmorMaterial)obj;
        return this.materialName.equals(another.materialName);
    }

    public int hashCode() {
        return this.materialName.hashCode();
    }

    private static ArmorMaterial createVanillaMaterial(String armorName, int durability, EnumMap<ArmorType, Integer> defence, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient) {
        ResourceKey<EquipmentAsset> modelId = Utils.instance.resources.createEquipmentResourceKey("angelblock", armorName);
        return new ArmorMaterial(durability, defence, enchantmentValue, equipSound, toughness, knockbackResistance, repairIngredient, modelId);
    }

    private static EnumMap<ArmorType, Integer> createArmorTypeMap(int bootsResistance, int leggingsResistance, int chestplateResistance, int helmetResistance, int bodyResistance) {
        return (EnumMap)Util.make(new EnumMap(ArmorType.class), armorTypeMap -> {
            armorTypeMap.put(ArmorType.BOOTS, bootsResistance);
            armorTypeMap.put(ArmorType.LEGGINGS, leggingsResistance);
            armorTypeMap.put(ArmorType.CHESTPLATE, chestplateResistance);
            armorTypeMap.put(ArmorType.HELMET, helmetResistance);
            armorTypeMap.put(ArmorType.BODY, bodyResistance);
        });
    }

    private static ModArmorMaterial copyOf(ModArmorMaterial armorMaterial, String armorModelName) {
        return new ModArmorMaterial(armorMaterial.materialName, armorModelName, armorMaterial.armorResistanceMap, armorMaterial.enchantmentValue, armorMaterial.toughness, armorMaterial.knockbackResistance, armorMaterial.durabilityMultiplier, armorMaterial.equipmentSound, armorMaterial.repairIngredient, armorMaterial.isFireResistant);
    }
}

