/*
 * Decompiled with CFR 0.152.
 */
package com.pekar.angelblock.blocks.tile_entities;

import com.pekar.angelblock.blocks.tile_entities.DespawnMonsterBlockEntity;
import com.pekar.angelblock.blocks.tile_entities.EntityRegistry;
import com.pekar.angelblock.blocks.tile_entities.monsters.IMonster;
import com.pekar.angelblock.blocks.tile_entities.monsters.Monsters;
import com.pekar.angelblock.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AngelBlockEntity
extends DespawnMonsterBlockEntity<AngelBlockEntity> {
    private static final String MonsterFilterTagName = "angelblock:MonsterFilter";
    private final Set<IMonster> monstersToIgnore = new HashSet<IMonster>();
    private final Map<Item, IMonster> monstersByActionItem = new HashMap<Item, IMonster>();
    private final Map<Byte, IMonster> monstersById = new HashMap<Byte, IMonster>();

    public AngelBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityRegistry.ANGEL_BLOCK_ENTITY.get(), blockPos, blockState);
        this.addToMonsterMap(Monsters.Skeleton);
        this.addToMonsterMap(Monsters.Zombie);
        this.addToMonsterMap(Monsters.Creeper);
        this.addToMonsterMap(Monsters.Enderman);
        this.addToMonsterMap(Monsters.Witch);
        this.addToMonsterMap(Monsters.Spider);
        this.addToMonsterMap(Monsters.CaveSpider);
        this.addToMonsterMap(Monsters.Vindicator);
        this.addToMonsterMap(Monsters.Slime);
        this.addToMonsterMap(Monsters.MagmaCube);
        this.addToMonsterMap(Monsters.WitherSkeleton);
        this.addToMonsterMap(Monsters.Guardian);
        this.addToMonsterMap(Monsters.ElderGuardian);
        this.addToMonsterMap(Monsters.Shulker);
        this.addToMonsterMap(Monsters.EnderDragon);
        this.addToMonsterMap(Monsters.Wither);
        this.addToMonsterMap(Monsters.Blaze);
        this.addToMonsterMap(Monsters.Ghast);
        this.addToMonsterMap(Monsters.Hoglin);
        this.addToMonsterMap(Monsters.Phantom);
        this.addToMonsterMap(Monsters.PiglinBrute);
        this.addToMonsterMap(Monsters.Warden);
        this.addToMonsterMap(Monsters.ZombieVillager);
        this.addToMonsterMap(Monsters.Evoker);
        this.addToMonsterMap(Monsters.Ravager);
        this.addToMonsterMap(Monsters.Piglin);
        this.addToMonsterMap(Monsters.Breeze);
        this.addToMonsterMap(Monsters.Creaking);
    }

    public boolean addMonsterToFilter(Item item, Player player) {
        if (!this.monstersByActionItem.containsKey(item)) {
            return false;
        }
        IMonster monster = this.monstersByActionItem.get(item);
        if (this.monstersToIgnore.contains(monster)) {
            this.monstersToIgnore.remove(monster);
        } else {
            this.monstersToIgnore.add(monster);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.setChanged();
        }
        Utils.instance.sound.playSoundByBlock(player, this.getBlockPos(), SoundEvents.DRIPSTONE_BLOCK_PLACE);
        return true;
    }

    public boolean resetFilter(Player player) {
        if (this.monstersInFilter() == 0) {
            return false;
        }
        this.monstersToIgnore.clear();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.setChanged();
        }
        Utils.instance.sound.playSoundByBlock(player, this.getBlockPos(), SoundEvents.MAGMA_CUBE_DEATH_SMALL);
        return true;
    }

    public int monstersInFilter() {
        return this.monstersToIgnore.size();
    }

    @Override
    protected double getEffectiveRadius() {
        return 70.0;
    }

    @Override
    protected boolean needToDespawnEntity(Entity entity) {
        return entity instanceof Enemy && this.monstersToIgnore.stream().noneMatch(m -> m.belongs((LivingEntity)entity));
    }

    @Override
    protected void loadModTag(CompoundTag tag) {
        byte[] array;
        this.monstersToIgnore.clear();
        for (byte monsterId : array = tag.getByteArray(MonsterFilterTagName).orElse(new byte[0])) {
            this.monstersToIgnore.add(this.monstersById.get(monsterId));
        }
    }

    @Override
    protected void saveModTag(CompoundTag tag) {
        byte[] array = new byte[this.monstersToIgnore.size()];
        int i = 0;
        for (IMonster monster : this.monstersToIgnore) {
            array[i++] = monster.getId();
        }
        tag.putByteArray(MonsterFilterTagName, array);
    }

    private void addToMonsterMap(IMonster monster) {
        this.monstersByActionItem.put(monster.getActionItem(), monster);
        this.monstersById.put(monster.getId(), monster);
    }
}

